package thomsonreuters.dss.api.content.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum InstrumentTypeGroup implements Enum {

    @JsonProperty("FuturesAndOptions")
    FUTURES_AND_OPTIONS("FuturesAndOptions", "0"),

    @JsonProperty("Equities")
    EQUITIES("Equities", "1"),

    @JsonProperty("Funds")
    FUNDS("Funds", "2"),

    @JsonProperty("GovCorp")
    GOV_CORP("GovCorp", "3"),

    @JsonProperty("MortgageBackedSecurities")
    MORTGAGE_BACKED_SECURITIES("MortgageBackedSecurities", "4"),

    @JsonProperty("CollatetizedMortgageObligations")
    COLLATETIZED_MORTGAGE_OBLIGATIONS("CollatetizedMortgageObligations", "5"),

    @JsonProperty("Municipals")
    MUNICIPALS("Municipals", "6"),

    @JsonProperty("Money")
    MONEY("Money", "7"),

    @JsonProperty("Commodities")
    COMMODITIES("Commodities", "8");

    private final String name;
    private final String value;

    private InstrumentTypeGroup(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
