package thomsonreuters.dss.api.content.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Month implements Enum {

    @JsonProperty("January")
    JANUARY("January", "1"),

    @JsonProperty("February")
    FEBRUARY("February", "2"),

    @JsonProperty("March")
    MARCH("March", "3"),

    @JsonProperty("April")
    APRIL("April", "4"),

    @JsonProperty("May")
    MAY("May", "5"),

    @JsonProperty("June")
    JUNE("June", "6"),

    @JsonProperty("July")
    JULY("July", "7"),

    @JsonProperty("August")
    AUGUST("August", "8"),

    @JsonProperty("September")
    SEPTEMBER("September", "9"),

    @JsonProperty("October")
    OCTOBER("October", "10"),

    @JsonProperty("November")
    NOVEMBER("November", "11"),

    @JsonProperty("December")
    DECEMBER("December", "12");

    private final String name;
    private final String value;

    private Month(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
