package thomsonreuters.dss.api.content.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum OtcsStatus implements Enum {

    @JsonProperty("All")
    ALL("All", "0"),

    @JsonProperty("Active")
    ACTIVE("Active", "1"),

    @JsonProperty("Inactive")
    INACTIVE("Inactive", "2");

    private final String name;
    private final String value;

    private OtcsStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
