package thomsonreuters.dss.api.content.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ValidityStatus implements Enum {

    @JsonProperty("Valid")
    VALID("Valid", "0"),

    @JsonProperty("NotFound")
    NOT_FOUND("NotFound", "1"),

    @JsonProperty("NotAnInstrument")
    NOT_AN_INSTRUMENT("NotAnInstrument", "2"),

    @JsonProperty("BadInstrumentType")
    BAD_INSTRUMENT_TYPE("BadInstrumentType", "3"),

    @JsonProperty("IsChainNotInstrument")
    IS_CHAIN_NOT_INSTRUMENT("IsChainNotInstrument", "4"),

    @JsonProperty("InstrumentNotPermitted")
    INSTRUMENT_NOT_PERMITTED("InstrumentNotPermitted", "5"),

    @JsonProperty("InstrumentNotReviewed")
    INSTRUMENT_NOT_REVIEWED("InstrumentNotReviewed", "6"),

    @JsonProperty("NotAChain")
    NOT_ACHAIN("NotAChain", "7"),

    @JsonProperty("ChainOfChains")
    CHAIN_OF_CHAINS("ChainOfChains", "8"),

    @JsonProperty("NotBeginningOfChain")
    NOT_BEGINNING_OF_CHAIN("NotBeginningOfChain", "9"),

    @JsonProperty("IsInstrumentNotChain")
    IS_INSTRUMENT_NOT_CHAIN("IsInstrumentNotChain", "10"),

    @JsonProperty("ChainNotPermitted")
    CHAIN_NOT_PERMITTED("ChainNotPermitted", "11"),

    @JsonProperty("ChainNotReviewed")
    CHAIN_NOT_REVIEWED("ChainNotReviewed", "12"),

    @JsonProperty("ChainHasBadLinks")
    CHAIN_HAS_BAD_LINKS("ChainHasBadLinks", "13");

    private final String name;
    private final String value;

    private ValidityStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
