package thomsonreuters.dss.api.content.equity.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EquityStatus implements Enum {

    @JsonProperty("Active")
    ACTIVE("Active", "0"),

    @JsonProperty("Inactive")
    INACTIVE("Inactive", "1");

    private final String name;
    private final String value;

    private EquityStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
