package thomsonreuters.dss.api.content.equity.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FairValueIndicator implements Enum {

    @JsonProperty("Yes")
    YES("Yes", "0"),

    @JsonProperty("No")
    NO("No", "1");

    private final String name;
    private final String value;

    private FairValueIndicator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
