package thomsonreuters.dss.api.content.fixedincome.mortgage.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MortgageAmortizationType implements Enum {

    @JsonProperty("Arm")
    ARM("Arm", "0"),

    @JsonProperty("ArmReverse")
    ARM_REVERSE("ArmReverse", "1"),

    @JsonProperty("Balloon")
    BALLOON("Balloon", "2"),

    @JsonProperty("BiWeekly")
    BI_WEEKLY("BiWeekly", "3"),

    @JsonProperty("FixedRateReverse")
    FIXED_RATE_REVERSE("FixedRateReverse", "4"),

    @JsonProperty("Gem")
    GEM("Gem", "5"),

    @JsonProperty("Gpm")
    GPM("Gpm", "6"),

    @JsonProperty("LevelPay")
    LEVEL_PAY("LevelPay", "7"),

    @JsonProperty("Tpm")
    TPM("Tpm", "8");

    private final String name;
    private final String value;

    private MortgageAmortizationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
