package thomsonreuters.dss.api.content.fixedincome.mortgage.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MortgageSecurityGroup implements Enum {

    @JsonProperty("AgencyPools")
    AGENCY_POOLS("AgencyPools", "0"),

    @JsonProperty("Generics")
    GENERICS("Generics", "1"),

    @JsonProperty("Tbas")
    TBAS("Tbas", "2");

    private final String name;
    private final String value;

    private MortgageSecurityGroup(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
