package thomsonreuters.dss.api.content.fixedincome.mortgage.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MortgageStatus implements Enum {

    @JsonProperty("ExchangedConverted")
    EXCHANGED_CONVERTED("ExchangedConverted", "0"),

    @JsonProperty("ExpiredMatured")
    EXPIRED_MATURED("ExpiredMatured", "1"),

    @JsonProperty("Issued")
    ISSUED("Issued", "2"),

    @JsonProperty("NotActive")
    NOT_ACTIVE("NotActive", "3");

    private final String name;
    private final String value;

    private MortgageStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
