package thomsonreuters.dss.api.content.fixedincome.usmunicipal.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UsMunicipalStatus implements Enum {

    @JsonProperty("Called")
    CALLED("Called", "0"),

    @JsonProperty("ExpiredMatured")
    EXPIRED_MATURED("ExpiredMatured", "1"),

    @JsonProperty("InDefault")
    IN_DEFAULT("InDefault", "2"),

    @JsonProperty("Issued")
    ISSUED("Issued", "3"),

    @JsonProperty("NotActive")
    NOT_ACTIVE("NotActive", "4"),

    @JsonProperty("ReOpening")
    RE_OPENING("ReOpening", "5"),

    @JsonProperty("RepaidBeforeMaturity")
    REPAID_BEFORE_MATURITY("RepaidBeforeMaturity", "6"),

    @JsonProperty("Tendered")
    TENDERED("Tendered", "7"),

    @JsonProperty("ToBeCalled")
    TO_BE_CALLED("ToBeCalled", "8"),

    @JsonProperty("ToBeIssued")
    TO_BE_ISSUED("ToBeIssued", "9");

    private final String name;
    private final String value;

    private UsMunicipalStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
