package thomsonreuters.dss.api.content.fund.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FundStatus implements Enum {

    @JsonProperty("Active")
    ACTIVE("Active", "0"),

    @JsonProperty("Inactive")
    INACTIVE("Inactive", "1");

    private final String name;
    private final String value;

    private FundStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
