package thomsonreuters.dss.api.content.fund.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FundSubType implements Enum {

    @JsonProperty("ClosedEndFund")
    CLOSED_END_FUND("ClosedEndFund", "0"),

    @JsonProperty("ExchangeTradedFund")
    EXCHANGE_TRADED_FUND("ExchangeTradedFund", "1"),

    @JsonProperty("InsuranceFund")
    INSURANCE_FUND("InsuranceFund", "2"),

    @JsonProperty("InvestmentFund")
    INVESTMENT_FUND("InvestmentFund", "3"),

    @JsonProperty("MutualFund")
    MUTUAL_FUND("MutualFund", "4"),

    @JsonProperty("PensionFund")
    PENSION_FUND("PensionFund", "5"),

    @JsonProperty("TassHedgeFund")
    TASS_HEDGE_FUND("TassHedgeFund", "6");

    private final String name;
    private final String value;

    private FundSubType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
