package thomsonreuters.dss.api.content.futuresandoptions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ExerciseStyle implements Enum {

    @JsonProperty("American")
    AMERICAN("American", "0"),

    @JsonProperty("European")
    EUROPEAN("European", "1");

    private final String name;
    private final String value;

    private ExerciseStyle(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
