package thomsonreuters.dss.api.content.futuresandoptions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FuturesAndOptionsType implements Enum {

    @JsonProperty("Futures")
    FUTURES("Futures", "0"),

    @JsonProperty("Options")
    OPTIONS("Options", "1"),

    @JsonProperty("FuturesOnOptions")
    FUTURES_ON_OPTIONS("FuturesOnOptions", "2");

    private final String name;
    private final String value;

    private FuturesAndOptionsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
