package thomsonreuters.dss.api.content.futuresandoptions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PutCall implements Enum {

    @JsonProperty("Put")
    PUT("Put", "0"),

    @JsonProperty("Call")
    CALL("Call", "1");

    private final String name;
    private final String value;

    private PutCall(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
