package thomsonreuters.dss.api.content.futuresandoptions.schema;

import com.github.davidmoten.odata.client.ODataType;

import java.util.HashMap;
import java.util.Map;

import thomsonreuters.dss.api.content.complex.AssetCategory;
import thomsonreuters.dss.api.content.complex.Country;
import thomsonreuters.dss.api.content.complex.Currency;
import thomsonreuters.dss.api.content.complex.Exchange;
import thomsonreuters.dss.api.content.complex.FileCode;
import thomsonreuters.dss.api.content.complex.GicsIndustryClassification;
import thomsonreuters.dss.api.content.complex.IndustrySector;
import thomsonreuters.dss.api.content.complex.InstrumentSubType;
import thomsonreuters.dss.api.content.complex.MoodyRating;
import thomsonreuters.dss.api.content.complex.StandardAndPoorsRating;
import thomsonreuters.dss.api.content.complex.State;
import thomsonreuters.dss.api.content.complex.TrBusinessClassification;
import thomsonreuters.dss.api.content.complex.ValidatedEntity;
import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.equity.complex.EquitySubType;
import thomsonreuters.dss.api.content.fixedincome.cmoabs.complex.CmoAbsSubGroupType;
import thomsonreuters.dss.api.content.fixedincome.govcorp.complex.GovCorpAssetStatus;
import thomsonreuters.dss.api.content.fixedincome.govcorp.complex.GovCorpContributor;
import thomsonreuters.dss.api.content.fixedincome.govcorp.complex.GovCorpSubGroup;
import thomsonreuters.dss.api.content.fixedincome.mortgage.complex.MortgageAgency;
import thomsonreuters.dss.api.content.fixedincome.mortgage.complex.MortgagePoolType;
import thomsonreuters.dss.api.search.complex.AllInstrumentSearchRequest;
import thomsonreuters.dss.api.search.complex.BenchmarkSearchRequest;
import thomsonreuters.dss.api.search.complex.BenchmarkSearchResult;
import thomsonreuters.dss.api.search.complex.CmoAbsSearchRequest;
import thomsonreuters.dss.api.search.complex.CmoAbsSecurityGroup;
import thomsonreuters.dss.api.search.complex.CommoditySearchRequest;
import thomsonreuters.dss.api.search.complex.CommoditySearchResult;
import thomsonreuters.dss.api.search.complex.DateComparison;
import thomsonreuters.dss.api.search.complex.DateRangeComparison;
import thomsonreuters.dss.api.search.complex.DateTimeRange;
import thomsonreuters.dss.api.search.complex.DateValueComparison;
import thomsonreuters.dss.api.search.complex.DecimalValueRange;
import thomsonreuters.dss.api.search.complex.EntitySearchRequest;
import thomsonreuters.dss.api.search.complex.EntitySearchResult;
import thomsonreuters.dss.api.search.complex.EquitySearchRequest;
import thomsonreuters.dss.api.search.complex.EquitySearchResult;
import thomsonreuters.dss.api.search.complex.FidHistoryEvent;
import thomsonreuters.dss.api.search.complex.FundSearchRequest;
import thomsonreuters.dss.api.search.complex.FundSearchResult;
import thomsonreuters.dss.api.search.complex.FuturesAndOptionsSearchRequest;
import thomsonreuters.dss.api.search.complex.FuturesAndOptionsSearchResult;
import thomsonreuters.dss.api.search.complex.GovCorpSearchRequest;
import thomsonreuters.dss.api.search.complex.GovCorpSecurityGroups;
import thomsonreuters.dss.api.search.complex.HistoricalBulkSearchIdentifier;
import thomsonreuters.dss.api.search.complex.HistoricalBulkSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalBulkSearchResult;
import thomsonreuters.dss.api.search.complex.HistoricalChainConstituent;
import thomsonreuters.dss.api.search.complex.HistoricalChainInstrument;
import thomsonreuters.dss.api.search.complex.HistoricalChainResolutionRequest;
import thomsonreuters.dss.api.search.complex.HistoricalCriteriaSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalInstrumentRicChangeHistory;
import thomsonreuters.dss.api.search.complex.HistoricalLookupEntry;
import thomsonreuters.dss.api.search.complex.HistoricalSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalSearchResult;
import thomsonreuters.dss.api.search.complex.MifidSubclassSearchRequest;
import thomsonreuters.dss.api.search.complex.MifidSubclassSearchResult;
import thomsonreuters.dss.api.search.complex.MortgageSearchRequest;
import thomsonreuters.dss.api.search.complex.NumericComparison;
import thomsonreuters.dss.api.search.complex.NumericRangeComparison;
import thomsonreuters.dss.api.search.complex.NumericValueComparison;
import thomsonreuters.dss.api.search.complex.OtcsSearchRequest;
import thomsonreuters.dss.api.search.complex.OtcsSearchResult;
import thomsonreuters.dss.api.search.complex.ReferenceHistoryRequest;
import thomsonreuters.dss.api.search.complex.ReferenceHistoryResult;
import thomsonreuters.dss.api.search.complex.UsMunicipalSearchRequest;

public enum SchemaInfo implements com.github.davidmoten.odata.client.SchemaInfo {

    INSTANCE;

    private final Map<String, Class<? extends ODataType>> classes = new HashMap<>();

    private SchemaInfo() {
        classes.put("ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest", AllInstrumentSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.EquitySearchRequest", EquitySearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.EquitySearchResult", EquitySearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest", FuturesAndOptionsSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult", FuturesAndOptionsSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.BenchmarkSearchRequest", BenchmarkSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.BenchmarkSearchResult", BenchmarkSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest", GovCorpSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.EntitySearchRequest", EntitySearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.FundSearchRequest", FundSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.FundSearchResult", FundSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.CommoditySearchRequest", CommoditySearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.CommoditySearchResult", CommoditySearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.MortgageSearchRequest", MortgageSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest", UsMunicipalSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest", CmoAbsSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.MifidSubclassSearchRequest", MifidSubclassSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.MifidSubclassSearchResult", MifidSubclassSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.OtcsSearchRequest", OtcsSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.OtcsSearchResult", OtcsSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest", HistoricalSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalSearchResult", HistoricalSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchRequest", HistoricalBulkSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchResult", HistoricalBulkSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalCriteriaSearchRequest", HistoricalCriteriaSearchRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalChainResolutionRequest", HistoricalChainResolutionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalChainInstrument", HistoricalChainInstrument.class);
        classes.put("ThomsonReuters.Dss.Api.Search.ReferenceHistoryRequest", ReferenceHistoryRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Search.ReferenceHistoryResult", ReferenceHistoryResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalLookupEntry", HistoricalLookupEntry.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory", HistoricalInstrumentRicChangeHistory.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalChainConstituent", HistoricalChainConstituent.class);
        classes.put("ThomsonReuters.Dss.Api.Search.NumericComparison", NumericComparison.class);
        classes.put("ThomsonReuters.Dss.Api.Search.NumericValueComparison", NumericValueComparison.class);
        classes.put("ThomsonReuters.Dss.Api.Search.NumericRangeComparison", NumericRangeComparison.class);
        classes.put("ThomsonReuters.Dss.Api.Search.DateComparison", DateComparison.class);
        classes.put("ThomsonReuters.Dss.Api.Search.DateValueComparison", DateValueComparison.class);
        classes.put("ThomsonReuters.Dss.Api.Search.DateRangeComparison", DateRangeComparison.class);
        classes.put("ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups", GovCorpSecurityGroups.class);
        classes.put("ThomsonReuters.Dss.Api.Search.EntitySearchResult", EntitySearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup", CmoAbsSecurityGroup.class);
        classes.put("ThomsonReuters.Dss.Api.Search.DateTimeRange", DateTimeRange.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier", HistoricalBulkSearchIdentifier.class);
        classes.put("ThomsonReuters.Dss.Api.Search.DecimalValueRange", DecimalValueRange.class);
        classes.put("ThomsonReuters.Dss.Api.Search.FidHistoryEvent", FidHistoryEvent.class);
        classes.put("ThomsonReuters.Dss.Api.Content.ValidatedInstrument", ValidatedInstrument.class);
        classes.put("ThomsonReuters.Dss.Api.Content.ValidatedEntity", ValidatedEntity.class);
        classes.put("ThomsonReuters.Dss.Api.Content.GicsIndustryClassification", GicsIndustryClassification.class);
        classes.put("ThomsonReuters.Dss.Api.Content.Exchange", Exchange.class);
        classes.put("ThomsonReuters.Dss.Api.Content.Country", Country.class);
        classes.put("ThomsonReuters.Dss.Api.Content.State", State.class);
        classes.put("ThomsonReuters.Dss.Api.Content.Currency", Currency.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FileCode", FileCode.class);
        classes.put("ThomsonReuters.Dss.Api.Content.TrBusinessClassification", TrBusinessClassification.class);
        classes.put("ThomsonReuters.Dss.Api.Content.IndustrySector", IndustrySector.class);
        classes.put("ThomsonReuters.Dss.Api.Content.MoodyRating", MoodyRating.class);
        classes.put("ThomsonReuters.Dss.Api.Content.StandardAndPoorsRating", StandardAndPoorsRating.class);
        classes.put("ThomsonReuters.Dss.Api.Content.AssetCategory", AssetCategory.class);
        classes.put("ThomsonReuters.Dss.Api.Content.InstrumentSubType", InstrumentSubType.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FixedIncome.GovCorp.GovCorpContributor", GovCorpContributor.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FixedIncome.GovCorp.GovCorpAssetStatus", GovCorpAssetStatus.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FixedIncome.GovCorp.GovCorpSubGroup", GovCorpSubGroup.class);
        classes.put("ThomsonReuters.Dss.Api.Content.Equity.EquitySubType", EquitySubType.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FixedIncome.Mortgage.MortgageAgency", MortgageAgency.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FixedIncome.Mortgage.MortgagePoolType", MortgagePoolType.class);
        classes.put("ThomsonReuters.Dss.Api.Content.FixedIncome.CmoAbs.CmoAbsSubGroupType", CmoAbsSubGroupType.class);
    }

    @Override
    public Class<? extends ODataType> getClassFromTypeWithNamespace(String name) {
        return classes.get(name);
    }

}
