package thomsonreuters.dss.api.extractions.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "MaxInstruments", 
    "MaxEntities", 
    "MaxInstrumentsPostExpansion", 
    "Description"})
public class ExtractionLimit implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MaxInstruments")
    protected Integer maxInstruments;

    @JsonProperty("MaxEntities")
    protected Integer maxEntities;

    @JsonProperty("MaxInstrumentsPostExpansion")
    protected Integer maxInstrumentsPostExpansion;

    @JsonProperty("Description")
    protected String description;

    protected ExtractionLimit() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionLimit";
    }

    @Property(name="MaxInstruments")
    @JsonIgnore
    public Optional<Integer> getMaxInstruments() {
        return Optional.ofNullable(maxInstruments);
    }

    public ExtractionLimit withMaxInstruments(Integer maxInstruments) {
        ExtractionLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionLimit");
        _x.maxInstruments = maxInstruments;
        return _x;
    }

    @Property(name="MaxEntities")
    @JsonIgnore
    public Optional<Integer> getMaxEntities() {
        return Optional.ofNullable(maxEntities);
    }

    public ExtractionLimit withMaxEntities(Integer maxEntities) {
        ExtractionLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionLimit");
        _x.maxEntities = maxEntities;
        return _x;
    }

    @Property(name="MaxInstrumentsPostExpansion")
    @JsonIgnore
    public Optional<Integer> getMaxInstrumentsPostExpansion() {
        return Optional.ofNullable(maxInstrumentsPostExpansion);
    }

    public ExtractionLimit withMaxInstrumentsPostExpansion(Integer maxInstrumentsPostExpansion) {
        ExtractionLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionLimit");
        _x.maxInstrumentsPostExpansion = maxInstrumentsPostExpansion;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ExtractionLimit withDescription(String description) {
        ExtractionLimit _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionLimit");
        _x.description = description;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer maxInstruments;
        private Integer maxEntities;
        private Integer maxInstrumentsPostExpansion;
        private String description;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder maxInstruments(Integer maxInstruments) {
            this.maxInstruments = maxInstruments;
            this.changedFields = changedFields.add("MaxInstruments");
            return this;
        }

        public Builder maxEntities(Integer maxEntities) {
            this.maxEntities = maxEntities;
            this.changedFields = changedFields.add("MaxEntities");
            return this;
        }

        public Builder maxInstrumentsPostExpansion(Integer maxInstrumentsPostExpansion) {
            this.maxInstrumentsPostExpansion = maxInstrumentsPostExpansion;
            this.changedFields = changedFields.add("MaxInstrumentsPostExpansion");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public ExtractionLimit build() {
            ExtractionLimit _x = new ExtractionLimit();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionLimit";
            _x.maxInstruments = maxInstruments;
            _x.maxEntities = maxEntities;
            _x.maxInstrumentsPostExpansion = maxInstrumentsPostExpansion;
            _x.description = description;
            return _x;
        }
    }

    private ExtractionLimit _copy() {
        ExtractionLimit _x = new ExtractionLimit();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.maxInstruments = maxInstruments;
        _x.maxEntities = maxEntities;
        _x.maxInstrumentsPostExpansion = maxInstrumentsPostExpansion;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractionLimit[");
        b.append("MaxInstruments=");
        b.append(this.maxInstruments);
        b.append(", ");
        b.append("MaxEntities=");
        b.append(this.maxEntities);
        b.append(", ");
        b.append("MaxInstrumentsPostExpansion=");
        b.append(this.maxInstrumentsPostExpansion);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
