package thomsonreuters.dss.api.extractions.container;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

import thomsonreuters.dss.api.content.complex.EntityIdentifier;
import thomsonreuters.dss.api.content.complex.InstrumentIdentifier;
import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentTypeGroup;
import thomsonreuters.dss.api.extractions.entity.set.BdfAssetTypes;
import thomsonreuters.dss.api.extractions.entity.set.BdfRegions;
import thomsonreuters.dss.api.extractions.entity.set.BondScheduleReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.BondScheduleTypes;
import thomsonreuters.dss.api.extractions.entity.set.CommoditiesCorrectionsHistoryReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.CompositeReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.ContentFieldTypes;
import thomsonreuters.dss.api.extractions.entity.set.ContentSetTypes;
import thomsonreuters.dss.api.extractions.entity.set.CorporateActionsIpoReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.CorporateActionsIsoReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.CorporateActionsStandardReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.CriteriaLists;
import thomsonreuters.dss.api.extractions.entity.set.ElektronTimeseriesReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.EndOfDayPricingReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.EntityListItems;
import thomsonreuters.dss.api.extractions.entity.set.EntityLists;
import thomsonreuters.dss.api.extractions.entity.set.EstimatesActualReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.EstimatesDetailReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.EstimatesFootnotesCompanyReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.EstimatesFootnotesDetailReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.EstimatesSummaryReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.ExchangeTypes;
import thomsonreuters.dss.api.extractions.entity.set.ExtractedFiles;
import thomsonreuters.dss.api.extractions.entity.set.ExtractionConditionSelectionItems;
import thomsonreuters.dss.api.extractions.entity.set.FixedIncomeAnalyticsReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.FundAllocationReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.HistoricalReferenceReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.InstrumentListItems;
import thomsonreuters.dss.api.extractions.entity.set.InstrumentLists;
import thomsonreuters.dss.api.extractions.entity.set.IntradayPricingReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.LegalEntityAuditReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.LegalEntityDetailReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.LegalEntityHierarchyReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.MBSFactorHistoryReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.NewsAnalyticsCommoditiesReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.NewsAnalyticsReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.NewsAttributionTypes;
import thomsonreuters.dss.api.extractions.entity.set.NewsCommodityTypes;
import thomsonreuters.dss.api.extractions.entity.set.NewsItemsReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.NewsLanguageTypes;
import thomsonreuters.dss.api.extractions.entity.set.NewsTopicTypes;
import thomsonreuters.dss.api.extractions.entity.set.OtherFiles;
import thomsonreuters.dss.api.extractions.entity.set.OwnershipReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.PremiumEndOfDayPricingReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.PremiumPricingReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.PriceHistoryReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.RatingSourceTypes;
import thomsonreuters.dss.api.extractions.entity.set.RatingsReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.RawExtractionResults;
import thomsonreuters.dss.api.extractions.entity.set.ReportExtractions;
import thomsonreuters.dss.api.extractions.entity.set.ReportTemplateTypes;
import thomsonreuters.dss.api.extractions.entity.set.ReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.Schedules;
import thomsonreuters.dss.api.extractions.entity.set.SingleHistoricalPriceReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.SinglePriceHistoryReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.StarmineReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.SymbolCrossReferenceReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TechnicalIndicatorsReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TermsAndConditionsReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TickHistoryIntradaySummariesReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TickHistoryMarketDepthReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TickHistoryRawReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TickHistoryTimeAndSalesReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TimeSeriesReportTemplates;
import thomsonreuters.dss.api.extractions.entity.set.TrancheFactorHistoryReportTemplates;
import thomsonreuters.dss.api.extractions.extractionconditions.entity.ExtractionConditionSelectionItem;
import thomsonreuters.dss.api.extractions.extractionconditions.entity.request.ExtractionConditionSelectionItemEntityRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRequestBase;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionResult;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRow;
import thomsonreuters.dss.api.extractions.extractionrequests.entity.RawExtractionResult;
import thomsonreuters.dss.api.extractions.extractionrequests.entity.request.RawExtractionResultEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.OtherFile;
import thomsonreuters.dss.api.extractions.reportextractions.entity.ReportExtraction;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ExtractedFileEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.OtherFileEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentField;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportTemplateImportSettings;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportTemplatesImportResult;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.BondScheduleType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ContentFieldType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ExchangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsAttributionType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsCommodityType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsLanguageType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsTopicType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.RatingSourceType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.BdfAssetTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.BdfRegionEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.BondScheduleReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.BondScheduleTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.CommoditiesCorrectionsHistoryReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.CompositeReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ContentFieldTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ContentSetTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.CorporateActionsIpoReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.CorporateActionsIsoReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.CorporateActionsStandardReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ElektronTimeseriesReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.EndOfDayPricingReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.EstimatesActualReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.EstimatesDetailReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.EstimatesFootnotesCompanyReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.EstimatesFootnotesDetailReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.EstimatesSummaryReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ExchangeTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.FixedIncomeAnalyticsReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.FundAllocationReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.HistoricalReferenceReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.IntradayPricingReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.LegalEntityAuditReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.LegalEntityDetailReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.LegalEntityHierarchyReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.MBSFactorHistoryReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsAnalyticsCommoditiesReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsAnalyticsReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsAttributionTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsCommodityTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsItemsReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsLanguageTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.NewsTopicTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.OwnershipReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.PremiumEndOfDayPricingReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.PremiumPricingReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.PriceHistoryReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.RatingSourceTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.RatingsReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.SingleHistoricalPriceReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.SinglePriceHistoryReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.StarmineReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.SymbolCrossReferenceReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TechnicalIndicatorsReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TermsAndConditionsReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TickHistoryIntradaySummariesReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TickHistoryMarketDepthReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TickHistoryRawReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TickHistoryTimeAndSalesReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TimeSeriesReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.TrancheFactorHistoryReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.schedules.complex.InstrumentTriggerDetail;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleImportResult;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleImportSettings;
import thomsonreuters.dss.api.extractions.schedules.entity.Schedule;
import thomsonreuters.dss.api.extractions.schedules.entity.request.ScheduleEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.complex.CriteriaListFilter;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesValidateIdentifiersResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityListImportResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityListImportSettings;
import thomsonreuters.dss.api.extractions.subjectlists.complex.FilterInfo;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentListImportResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentListImportSettings;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentListValidationOptions;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentsValidateIdentifiersResult;
import thomsonreuters.dss.api.extractions.subjectlists.entity.CriteriaList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.EntityList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.InstrumentList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.CriteriaListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.EntityListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.EntityListItemEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListItemEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.enums.CriteriaListType;
import thomsonreuters.dss.api.search.complex.HistoricalLookupEntry;

public final class Extractions implements HasContext {

    private final ContextPath contextPath;

    public Extractions(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<Extractions> {

        @Override
        public Extractions _create(Context context) {
            return new Extractions(context);
        }
    }

    public static BuilderBase<ContainerBuilder<Extractions>, Extractions> test() {
        return new ContainerBuilderImpl();
    }

    public RawExtractionResults rawExtractionResults() {
        return new RawExtractionResults(
                        contextPath.addSegment("RawExtractionResults"));
    }

    public RawExtractionResultEntityRequest rawExtractionResults(String jobId) {
        return new RawExtractionResultEntityRequest(contextPath.addSegment("RawExtractionResults").addKeys(new NameValue(jobId.toString())));
    }

    public OtherFiles otherFiles() {
        return new OtherFiles(
                        contextPath.addSegment("OtherFiles"));
    }

    public OtherFileEntityRequest otherFiles(String otherFileId) {
        return new OtherFileEntityRequest(contextPath.addSegment("OtherFiles").addKeys(new NameValue(otherFileId.toString())));
    }

    public ExtractedFiles extractedFiles() {
        return new ExtractedFiles(
                        contextPath.addSegment("ExtractedFiles"));
    }

    public ExtractedFileEntityRequest extractedFiles(String extractedFileId) {
        return new ExtractedFileEntityRequest(contextPath.addSegment("ExtractedFiles").addKeys(new NameValue(extractedFileId.toString())));
    }

    public ReportExtractions reportExtractions() {
        return new ReportExtractions(
                        contextPath.addSegment("ReportExtractions"));
    }

    public ReportExtractionEntityRequest reportExtractions(String reportExtractionId) {
        return new ReportExtractionEntityRequest(contextPath.addSegment("ReportExtractions").addKeys(new NameValue(reportExtractionId.toString())));
    }

    public ExchangeTypes exchangeTypes() {
        return new ExchangeTypes(
                        contextPath.addSegment("ExchangeTypes"));
    }

    public ExchangeTypeEntityRequest exchangeTypes(String code) {
        return new ExchangeTypeEntityRequest(contextPath.addSegment("ExchangeTypes").addKeys(new NameValue(code.toString())));
    }

    public BdfRegions bdfRegions() {
        return new BdfRegions(
                        contextPath.addSegment("BdfRegions"));
    }

    public BdfRegionEntityRequest bdfRegions(String code) {
        return new BdfRegionEntityRequest(contextPath.addSegment("BdfRegions").addKeys(new NameValue(code.toString())));
    }

    public NewsAttributionTypes newsAttributionTypes() {
        return new NewsAttributionTypes(
                        contextPath.addSegment("NewsAttributionTypes"));
    }

    public NewsAttributionTypeEntityRequest newsAttributionTypes(String code) {
        return new NewsAttributionTypeEntityRequest(contextPath.addSegment("NewsAttributionTypes").addKeys(new NameValue(code.toString())));
    }

    public NewsCommodityTypes newsCommodityTypes() {
        return new NewsCommodityTypes(
                        contextPath.addSegment("NewsCommodityTypes"));
    }

    public NewsCommodityTypeEntityRequest newsCommodityTypes(String code) {
        return new NewsCommodityTypeEntityRequest(contextPath.addSegment("NewsCommodityTypes").addKeys(new NameValue(code.toString())));
    }

    public NewsLanguageTypes newsLanguageTypes() {
        return new NewsLanguageTypes(
                        contextPath.addSegment("NewsLanguageTypes"));
    }

    public NewsLanguageTypeEntityRequest newsLanguageTypes(String code) {
        return new NewsLanguageTypeEntityRequest(contextPath.addSegment("NewsLanguageTypes").addKeys(new NameValue(code.toString())));
    }

    public NewsTopicTypes newsTopicTypes() {
        return new NewsTopicTypes(
                        contextPath.addSegment("NewsTopicTypes"));
    }

    public NewsTopicTypeEntityRequest newsTopicTypes(String code) {
        return new NewsTopicTypeEntityRequest(contextPath.addSegment("NewsTopicTypes").addKeys(new NameValue(code.toString())));
    }

    public RatingSourceTypes ratingSourceTypes() {
        return new RatingSourceTypes(
                        contextPath.addSegment("RatingSourceTypes"));
    }

    public RatingSourceTypeEntityRequest ratingSourceTypes(String code) {
        return new RatingSourceTypeEntityRequest(contextPath.addSegment("RatingSourceTypes").addKeys(new NameValue(code.toString())));
    }

    public ExtractionConditionSelectionItems extractionConditionSelectionItems() {
        return new ExtractionConditionSelectionItems(
                        contextPath.addSegment("ExtractionConditionSelectionItems"));
    }

    public ExtractionConditionSelectionItemEntityRequest extractionConditionSelectionItems(String code) {
        return new ExtractionConditionSelectionItemEntityRequest(contextPath.addSegment("ExtractionConditionSelectionItems").addKeys(new NameValue(code.toString())));
    }

    public BdfAssetTypes bdfAssetTypes() {
        return new BdfAssetTypes(
                        contextPath.addSegment("BdfAssetTypes"));
    }

    public BdfAssetTypeEntityRequest bdfAssetTypes(String code) {
        return new BdfAssetTypeEntityRequest(contextPath.addSegment("BdfAssetTypes").addKeys(new NameValue(code.toString())));
    }

    public BondScheduleTypes bondScheduleTypes() {
        return new BondScheduleTypes(
                        contextPath.addSegment("BondScheduleTypes"));
    }

    public BondScheduleTypeEntityRequest bondScheduleTypes(String code) {
        return new BondScheduleTypeEntityRequest(contextPath.addSegment("BondScheduleTypes").addKeys(new NameValue(code.toString())));
    }

    public ContentSetTypes contentSetTypes() {
        return new ContentSetTypes(
                        contextPath.addSegment("ContentSetTypes"));
    }

    public ContentSetTypeEntityRequest contentSetTypes(String code) {
        return new ContentSetTypeEntityRequest(contextPath.addSegment("ContentSetTypes").addKeys(new NameValue(code.toString())));
    }

    public ContentFieldTypes contentFieldTypes() {
        return new ContentFieldTypes(
                        contextPath.addSegment("ContentFieldTypes"));
    }

    public ContentFieldTypeEntityRequest contentFieldTypes(String code) {
        return new ContentFieldTypeEntityRequest(contextPath.addSegment("ContentFieldTypes").addKeys(new NameValue(code.toString())));
    }

    public ReportTemplateTypes reportTemplateTypes() {
        return new ReportTemplateTypes(
                        contextPath.addSegment("ReportTemplateTypes"));
    }

    public ReportTemplateTypeEntityRequest reportTemplateTypes(String code) {
        return new ReportTemplateTypeEntityRequest(contextPath.addSegment("ReportTemplateTypes").addKeys(new NameValue(code.toString())));
    }

    public CriteriaLists criteriaLists() {
        return new CriteriaLists(
                        contextPath.addSegment("CriteriaLists"));
    }

    public CriteriaListEntityRequest criteriaLists(String listId) {
        return new CriteriaListEntityRequest(contextPath.addSegment("CriteriaLists").addKeys(new NameValue(listId.toString())));
    }

    public EntityLists entityLists() {
        return new EntityLists(
                        contextPath.addSegment("EntityLists"));
    }

    public EntityListEntityRequest entityLists(String listId) {
        return new EntityListEntityRequest(contextPath.addSegment("EntityLists").addKeys(new NameValue(listId.toString())));
    }

    public EntityListItems entityListItems() {
        return new EntityListItems(
                        contextPath.addSegment("EntityListItems"));
    }

    public EntityListItemEntityRequest entityListItems(String entityListItemKey) {
        return new EntityListItemEntityRequest(contextPath.addSegment("EntityListItems").addKeys(new NameValue(entityListItemKey.toString())));
    }

    public InstrumentLists instrumentLists() {
        return new InstrumentLists(
                        contextPath.addSegment("InstrumentLists"));
    }

    public InstrumentListEntityRequest instrumentLists(String listId) {
        return new InstrumentListEntityRequest(contextPath.addSegment("InstrumentLists").addKeys(new NameValue(listId.toString())));
    }

    public InstrumentListItems instrumentListItems() {
        return new InstrumentListItems(
                        contextPath.addSegment("InstrumentListItems"));
    }

    public InstrumentListItemEntityRequest instrumentListItems(String instrumentListItemKey) {
        return new InstrumentListItemEntityRequest(contextPath.addSegment("InstrumentListItems").addKeys(new NameValue(instrumentListItemKey.toString())));
    }

    public Schedules schedules() {
        return new Schedules(
                        contextPath.addSegment("Schedules"));
    }

    public ScheduleEntityRequest schedules(String scheduleId) {
        return new ScheduleEntityRequest(contextPath.addSegment("Schedules").addKeys(new NameValue(scheduleId.toString())));
    }

    public ReportTemplates reportTemplates() {
        return new ReportTemplates(
                        contextPath.addSegment("ReportTemplates"));
    }

    public ReportTemplateEntityRequest reportTemplates(String reportTemplateId) {
        return new ReportTemplateEntityRequest(contextPath.addSegment("ReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public CommoditiesCorrectionsHistoryReportTemplates commoditiesCorrectionsHistoryReportTemplates() {
        return new CommoditiesCorrectionsHistoryReportTemplates(
                        contextPath.addSegment("CommoditiesCorrectionsHistoryReportTemplates"));
    }

    public CommoditiesCorrectionsHistoryReportTemplateEntityRequest commoditiesCorrectionsHistoryReportTemplates(String reportTemplateId) {
        return new CommoditiesCorrectionsHistoryReportTemplateEntityRequest(contextPath.addSegment("CommoditiesCorrectionsHistoryReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public SinglePriceHistoryReportTemplates singlePriceHistoryReportTemplates() {
        return new SinglePriceHistoryReportTemplates(
                        contextPath.addSegment("SinglePriceHistoryReportTemplates"));
    }

    public SinglePriceHistoryReportTemplateEntityRequest singlePriceHistoryReportTemplates(String reportTemplateId) {
        return new SinglePriceHistoryReportTemplateEntityRequest(contextPath.addSegment("SinglePriceHistoryReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public PriceHistoryReportTemplates priceHistoryReportTemplates() {
        return new PriceHistoryReportTemplates(
                        contextPath.addSegment("PriceHistoryReportTemplates"));
    }

    public PriceHistoryReportTemplateEntityRequest priceHistoryReportTemplates(String reportTemplateId) {
        return new PriceHistoryReportTemplateEntityRequest(contextPath.addSegment("PriceHistoryReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public ElektronTimeseriesReportTemplates elektronTimeseriesReportTemplates() {
        return new ElektronTimeseriesReportTemplates(
                        contextPath.addSegment("ElektronTimeseriesReportTemplates"));
    }

    public ElektronTimeseriesReportTemplateEntityRequest elektronTimeseriesReportTemplates(String reportTemplateId) {
        return new ElektronTimeseriesReportTemplateEntityRequest(contextPath.addSegment("ElektronTimeseriesReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public HistoricalReferenceReportTemplates historicalReferenceReportTemplates() {
        return new HistoricalReferenceReportTemplates(
                        contextPath.addSegment("HistoricalReferenceReportTemplates"));
    }

    public HistoricalReferenceReportTemplateEntityRequest historicalReferenceReportTemplates(String reportTemplateId) {
        return new HistoricalReferenceReportTemplateEntityRequest(contextPath.addSegment("HistoricalReferenceReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TickHistoryIntradaySummariesReportTemplates tickHistoryIntradaySummariesReportTemplates() {
        return new TickHistoryIntradaySummariesReportTemplates(
                        contextPath.addSegment("TickHistoryIntradaySummariesReportTemplates"));
    }

    public TickHistoryIntradaySummariesReportTemplateEntityRequest tickHistoryIntradaySummariesReportTemplates(String reportTemplateId) {
        return new TickHistoryIntradaySummariesReportTemplateEntityRequest(contextPath.addSegment("TickHistoryIntradaySummariesReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TickHistoryRawReportTemplates tickHistoryRawReportTemplates() {
        return new TickHistoryRawReportTemplates(
                        contextPath.addSegment("TickHistoryRawReportTemplates"));
    }

    public TickHistoryRawReportTemplateEntityRequest tickHistoryRawReportTemplates(String reportTemplateId) {
        return new TickHistoryRawReportTemplateEntityRequest(contextPath.addSegment("TickHistoryRawReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TickHistoryTimeAndSalesReportTemplates tickHistoryTimeAndSalesReportTemplates() {
        return new TickHistoryTimeAndSalesReportTemplates(
                        contextPath.addSegment("TickHistoryTimeAndSalesReportTemplates"));
    }

    public TickHistoryTimeAndSalesReportTemplateEntityRequest tickHistoryTimeAndSalesReportTemplates(String reportTemplateId) {
        return new TickHistoryTimeAndSalesReportTemplateEntityRequest(contextPath.addSegment("TickHistoryTimeAndSalesReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TickHistoryMarketDepthReportTemplates tickHistoryMarketDepthReportTemplates() {
        return new TickHistoryMarketDepthReportTemplates(
                        contextPath.addSegment("TickHistoryMarketDepthReportTemplates"));
    }

    public TickHistoryMarketDepthReportTemplateEntityRequest tickHistoryMarketDepthReportTemplates(String reportTemplateId) {
        return new TickHistoryMarketDepthReportTemplateEntityRequest(contextPath.addSegment("TickHistoryMarketDepthReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public BondScheduleReportTemplates bondScheduleReportTemplates() {
        return new BondScheduleReportTemplates(
                        contextPath.addSegment("BondScheduleReportTemplates"));
    }

    public BondScheduleReportTemplateEntityRequest bondScheduleReportTemplates(String reportTemplateId) {
        return new BondScheduleReportTemplateEntityRequest(contextPath.addSegment("BondScheduleReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public CorporateActionsIpoReportTemplates corporateActionsIpoReportTemplates() {
        return new CorporateActionsIpoReportTemplates(
                        contextPath.addSegment("CorporateActionsIpoReportTemplates"));
    }

    public CorporateActionsIpoReportTemplateEntityRequest corporateActionsIpoReportTemplates(String reportTemplateId) {
        return new CorporateActionsIpoReportTemplateEntityRequest(contextPath.addSegment("CorporateActionsIpoReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public CorporateActionsIsoReportTemplates corporateActionsIsoReportTemplates() {
        return new CorporateActionsIsoReportTemplates(
                        contextPath.addSegment("CorporateActionsIsoReportTemplates"));
    }

    public CorporateActionsIsoReportTemplateEntityRequest corporateActionsIsoReportTemplates(String reportTemplateId) {
        return new CorporateActionsIsoReportTemplateEntityRequest(contextPath.addSegment("CorporateActionsIsoReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public CorporateActionsStandardReportTemplates corporateActionsStandardReportTemplates() {
        return new CorporateActionsStandardReportTemplates(
                        contextPath.addSegment("CorporateActionsStandardReportTemplates"));
    }

    public CorporateActionsStandardReportTemplateEntityRequest corporateActionsStandardReportTemplates(String reportTemplateId) {
        return new CorporateActionsStandardReportTemplateEntityRequest(contextPath.addSegment("CorporateActionsStandardReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public EstimatesActualReportTemplates estimatesActualReportTemplates() {
        return new EstimatesActualReportTemplates(
                        contextPath.addSegment("EstimatesActualReportTemplates"));
    }

    public EstimatesActualReportTemplateEntityRequest estimatesActualReportTemplates(String reportTemplateId) {
        return new EstimatesActualReportTemplateEntityRequest(contextPath.addSegment("EstimatesActualReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public EstimatesDetailReportTemplates estimatesDetailReportTemplates() {
        return new EstimatesDetailReportTemplates(
                        contextPath.addSegment("EstimatesDetailReportTemplates"));
    }

    public EstimatesDetailReportTemplateEntityRequest estimatesDetailReportTemplates(String reportTemplateId) {
        return new EstimatesDetailReportTemplateEntityRequest(contextPath.addSegment("EstimatesDetailReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public EstimatesFootnotesCompanyReportTemplates estimatesFootnotesCompanyReportTemplates() {
        return new EstimatesFootnotesCompanyReportTemplates(
                        contextPath.addSegment("EstimatesFootnotesCompanyReportTemplates"));
    }

    public EstimatesFootnotesCompanyReportTemplateEntityRequest estimatesFootnotesCompanyReportTemplates(String reportTemplateId) {
        return new EstimatesFootnotesCompanyReportTemplateEntityRequest(contextPath.addSegment("EstimatesFootnotesCompanyReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public EstimatesFootnotesDetailReportTemplates estimatesFootnotesDetailReportTemplates() {
        return new EstimatesFootnotesDetailReportTemplates(
                        contextPath.addSegment("EstimatesFootnotesDetailReportTemplates"));
    }

    public EstimatesFootnotesDetailReportTemplateEntityRequest estimatesFootnotesDetailReportTemplates(String reportTemplateId) {
        return new EstimatesFootnotesDetailReportTemplateEntityRequest(contextPath.addSegment("EstimatesFootnotesDetailReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public EstimatesSummaryReportTemplates estimatesSummaryReportTemplates() {
        return new EstimatesSummaryReportTemplates(
                        contextPath.addSegment("EstimatesSummaryReportTemplates"));
    }

    public EstimatesSummaryReportTemplateEntityRequest estimatesSummaryReportTemplates(String reportTemplateId) {
        return new EstimatesSummaryReportTemplateEntityRequest(contextPath.addSegment("EstimatesSummaryReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public FundAllocationReportTemplates fundAllocationReportTemplates() {
        return new FundAllocationReportTemplates(
                        contextPath.addSegment("FundAllocationReportTemplates"));
    }

    public FundAllocationReportTemplateEntityRequest fundAllocationReportTemplates(String reportTemplateId) {
        return new FundAllocationReportTemplateEntityRequest(contextPath.addSegment("FundAllocationReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public LegalEntityDetailReportTemplates legalEntityDetailReportTemplates() {
        return new LegalEntityDetailReportTemplates(
                        contextPath.addSegment("LegalEntityDetailReportTemplates"));
    }

    public LegalEntityDetailReportTemplateEntityRequest legalEntityDetailReportTemplates(String reportTemplateId) {
        return new LegalEntityDetailReportTemplateEntityRequest(contextPath.addSegment("LegalEntityDetailReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public LegalEntityHierarchyReportTemplates legalEntityHierarchyReportTemplates() {
        return new LegalEntityHierarchyReportTemplates(
                        contextPath.addSegment("LegalEntityHierarchyReportTemplates"));
    }

    public LegalEntityHierarchyReportTemplateEntityRequest legalEntityHierarchyReportTemplates(String reportTemplateId) {
        return new LegalEntityHierarchyReportTemplateEntityRequest(contextPath.addSegment("LegalEntityHierarchyReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public NewsAnalyticsCommoditiesReportTemplates newsAnalyticsCommoditiesReportTemplates() {
        return new NewsAnalyticsCommoditiesReportTemplates(
                        contextPath.addSegment("NewsAnalyticsCommoditiesReportTemplates"));
    }

    public NewsAnalyticsCommoditiesReportTemplateEntityRequest newsAnalyticsCommoditiesReportTemplates(String reportTemplateId) {
        return new NewsAnalyticsCommoditiesReportTemplateEntityRequest(contextPath.addSegment("NewsAnalyticsCommoditiesReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public NewsItemsReportTemplates newsItemsReportTemplates() {
        return new NewsItemsReportTemplates(
                        contextPath.addSegment("NewsItemsReportTemplates"));
    }

    public NewsItemsReportTemplateEntityRequest newsItemsReportTemplates(String reportTemplateId) {
        return new NewsItemsReportTemplateEntityRequest(contextPath.addSegment("NewsItemsReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public PremiumEndOfDayPricingReportTemplates premiumEndOfDayPricingReportTemplates() {
        return new PremiumEndOfDayPricingReportTemplates(
                        contextPath.addSegment("PremiumEndOfDayPricingReportTemplates"));
    }

    public PremiumEndOfDayPricingReportTemplateEntityRequest premiumEndOfDayPricingReportTemplates(String reportTemplateId) {
        return new PremiumEndOfDayPricingReportTemplateEntityRequest(contextPath.addSegment("PremiumEndOfDayPricingReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public PremiumPricingReportTemplates premiumPricingReportTemplates() {
        return new PremiumPricingReportTemplates(
                        contextPath.addSegment("PremiumPricingReportTemplates"));
    }

    public PremiumPricingReportTemplateEntityRequest premiumPricingReportTemplates(String reportTemplateId) {
        return new PremiumPricingReportTemplateEntityRequest(contextPath.addSegment("PremiumPricingReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public RatingsReportTemplates ratingsReportTemplates() {
        return new RatingsReportTemplates(
                        contextPath.addSegment("RatingsReportTemplates"));
    }

    public RatingsReportTemplateEntityRequest ratingsReportTemplates(String reportTemplateId) {
        return new RatingsReportTemplateEntityRequest(contextPath.addSegment("RatingsReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public SingleHistoricalPriceReportTemplates singleHistoricalPriceReportTemplates() {
        return new SingleHistoricalPriceReportTemplates(
                        contextPath.addSegment("SingleHistoricalPriceReportTemplates"));
    }

    public SingleHistoricalPriceReportTemplateEntityRequest singleHistoricalPriceReportTemplates(String reportTemplateId) {
        return new SingleHistoricalPriceReportTemplateEntityRequest(contextPath.addSegment("SingleHistoricalPriceReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public StarmineReportTemplates starmineReportTemplates() {
        return new StarmineReportTemplates(
                        contextPath.addSegment("StarmineReportTemplates"));
    }

    public StarmineReportTemplateEntityRequest starmineReportTemplates(String reportTemplateId) {
        return new StarmineReportTemplateEntityRequest(contextPath.addSegment("StarmineReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public SymbolCrossReferenceReportTemplates symbolCrossReferenceReportTemplates() {
        return new SymbolCrossReferenceReportTemplates(
                        contextPath.addSegment("SymbolCrossReferenceReportTemplates"));
    }

    public SymbolCrossReferenceReportTemplateEntityRequest symbolCrossReferenceReportTemplates(String reportTemplateId) {
        return new SymbolCrossReferenceReportTemplateEntityRequest(contextPath.addSegment("SymbolCrossReferenceReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public CompositeReportTemplates compositeReportTemplates() {
        return new CompositeReportTemplates(
                        contextPath.addSegment("CompositeReportTemplates"));
    }

    public CompositeReportTemplateEntityRequest compositeReportTemplates(String reportTemplateId) {
        return new CompositeReportTemplateEntityRequest(contextPath.addSegment("CompositeReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public OwnershipReportTemplates ownershipReportTemplates() {
        return new OwnershipReportTemplates(
                        contextPath.addSegment("OwnershipReportTemplates"));
    }

    public OwnershipReportTemplateEntityRequest ownershipReportTemplates(String reportTemplateId) {
        return new OwnershipReportTemplateEntityRequest(contextPath.addSegment("OwnershipReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TrancheFactorHistoryReportTemplates trancheFactorHistoryReportTemplates() {
        return new TrancheFactorHistoryReportTemplates(
                        contextPath.addSegment("TrancheFactorHistoryReportTemplates"));
    }

    public TrancheFactorHistoryReportTemplateEntityRequest trancheFactorHistoryReportTemplates(String reportTemplateId) {
        return new TrancheFactorHistoryReportTemplateEntityRequest(contextPath.addSegment("TrancheFactorHistoryReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public MBSFactorHistoryReportTemplates mBSFactorHistoryReportTemplates() {
        return new MBSFactorHistoryReportTemplates(
                        contextPath.addSegment("MBSFactorHistoryReportTemplates"));
    }

    public MBSFactorHistoryReportTemplateEntityRequest mBSFactorHistoryReportTemplates(String reportTemplateId) {
        return new MBSFactorHistoryReportTemplateEntityRequest(contextPath.addSegment("MBSFactorHistoryReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public LegalEntityAuditReportTemplates legalEntityAuditReportTemplates() {
        return new LegalEntityAuditReportTemplates(
                        contextPath.addSegment("LegalEntityAuditReportTemplates"));
    }

    public LegalEntityAuditReportTemplateEntityRequest legalEntityAuditReportTemplates(String reportTemplateId) {
        return new LegalEntityAuditReportTemplateEntityRequest(contextPath.addSegment("LegalEntityAuditReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TechnicalIndicatorsReportTemplates technicalIndicatorsReportTemplates() {
        return new TechnicalIndicatorsReportTemplates(
                        contextPath.addSegment("TechnicalIndicatorsReportTemplates"));
    }

    public TechnicalIndicatorsReportTemplateEntityRequest technicalIndicatorsReportTemplates(String reportTemplateId) {
        return new TechnicalIndicatorsReportTemplateEntityRequest(contextPath.addSegment("TechnicalIndicatorsReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public FixedIncomeAnalyticsReportTemplates fixedIncomeAnalyticsReportTemplates() {
        return new FixedIncomeAnalyticsReportTemplates(
                        contextPath.addSegment("FixedIncomeAnalyticsReportTemplates"));
    }

    public FixedIncomeAnalyticsReportTemplateEntityRequest fixedIncomeAnalyticsReportTemplates(String reportTemplateId) {
        return new FixedIncomeAnalyticsReportTemplateEntityRequest(contextPath.addSegment("FixedIncomeAnalyticsReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public IntradayPricingReportTemplates intradayPricingReportTemplates() {
        return new IntradayPricingReportTemplates(
                        contextPath.addSegment("IntradayPricingReportTemplates"));
    }

    public IntradayPricingReportTemplateEntityRequest intradayPricingReportTemplates(String reportTemplateId) {
        return new IntradayPricingReportTemplateEntityRequest(contextPath.addSegment("IntradayPricingReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public EndOfDayPricingReportTemplates endOfDayPricingReportTemplates() {
        return new EndOfDayPricingReportTemplates(
                        contextPath.addSegment("EndOfDayPricingReportTemplates"));
    }

    public EndOfDayPricingReportTemplateEntityRequest endOfDayPricingReportTemplates(String reportTemplateId) {
        return new EndOfDayPricingReportTemplateEntityRequest(contextPath.addSegment("EndOfDayPricingReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public NewsAnalyticsReportTemplates newsAnalyticsReportTemplates() {
        return new NewsAnalyticsReportTemplates(
                        contextPath.addSegment("NewsAnalyticsReportTemplates"));
    }

    public NewsAnalyticsReportTemplateEntityRequest newsAnalyticsReportTemplates(String reportTemplateId) {
        return new NewsAnalyticsReportTemplateEntityRequest(contextPath.addSegment("NewsAnalyticsReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TermsAndConditionsReportTemplates termsAndConditionsReportTemplates() {
        return new TermsAndConditionsReportTemplates(
                        contextPath.addSegment("TermsAndConditionsReportTemplates"));
    }

    public TermsAndConditionsReportTemplateEntityRequest termsAndConditionsReportTemplates(String reportTemplateId) {
        return new TermsAndConditionsReportTemplateEntityRequest(contextPath.addSegment("TermsAndConditionsReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    public TimeSeriesReportTemplates timeSeriesReportTemplates() {
        return new TimeSeriesReportTemplates(
                        contextPath.addSegment("TimeSeriesReportTemplates"));
    }

    public TimeSeriesReportTemplateEntityRequest timeSeriesReportTemplates(String reportTemplateId) {
        return new TimeSeriesReportTemplateEntityRequest(contextPath.addSegment("TimeSeriesReportTemplates").addKeys(new NameValue(reportTemplateId.toString())));
    }

    @Action(name = "OtherFileDeleteMultiple")
    @JsonIgnore
    public ActionRequestNoReturn otherFileDeleteMultiple(List<String> fileIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileIds", "Collection(Edm.String)", fileIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.OtherFileDeleteMultiple"), _parameters);
    }

    @Action(name = "ExtractedFileDeleteMultiple")
    @JsonIgnore
    public ActionRequestNoReturn extractedFileDeleteMultiple(List<String> extractedFileIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractedFileIds", "Collection(Edm.String)", extractedFileIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ExtractedFileDeleteMultiple"), _parameters);
    }

    @Action(name = "CriteriaListCreate")
    @JsonIgnore
    public ActionRequestReturningNonCollection<CriteriaList> criteriaListCreate(String listName, CriteriaListType type, List<CriteriaListFilter> filters) {
        Preconditions.checkNotNull(type, "type cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListName", "Edm.String", listName)
            .put("Type", "ThomsonReuters.Dss.Api.Extractions.SubjectLists.CriteriaListType", type)
            .put("Filters", "Collection(ThomsonReuters.Dss.Api.Extractions.SubjectLists.CriteriaListFilter)", filters)
            .build();
        return new ActionRequestReturningNonCollection<CriteriaList>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListCreate"), CriteriaList.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "CriteriaListDeleteMultiple")
    @JsonIgnore
    public ActionRequestNoReturn criteriaListDeleteMultiple(List<String> listIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListIds", "Collection(Edm.String)", listIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListDeleteMultiple"), _parameters);
    }

    @Action(name = "CriteriaListDeleteAllForUser")
    @JsonIgnore
    public ActionRequestNoReturn criteriaListDeleteAllForUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListDeleteAllForUser"), _parameters);
    }

    @Action(name = "CriteriaListUpdateFilters")
    @JsonIgnore
    public ActionRequestNoReturn criteriaListUpdateFilters(String listId, List<CriteriaListFilter> filters) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListId", "Edm.String", listId)
            .put("Filters", "Collection(ThomsonReuters.Dss.Api.Extractions.SubjectLists.CriteriaListFilter)", filters)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListUpdateFilters"), _parameters);
    }

    @Action(name = "EntityListDeleteMultiple")
    @JsonIgnore
    public ActionRequestNoReturn entityListDeleteMultiple(List<String> entityListIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityListIds", "Collection(Edm.String)", entityListIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.EntityListDeleteMultiple"), _parameters);
    }

    @Action(name = "EntityListDeleteAllForUser")
    @JsonIgnore
    public ActionRequestNoReturn entityListDeleteAllForUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.EntityListDeleteAllForUser"), _parameters);
    }

    @Action(name = "EntityListImportFromBytes")
    @JsonIgnore
    public ActionRequestReturningNonCollection<EntityListImportResult> entityListImportFromBytes(String fileName, byte[] fileBytes, EntityListImportSettings settings) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileName", "Edm.String", fileName)
            .put("FileBytes", "Edm.Binary", fileBytes)
            .put("Settings", "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings", settings)
            .build();
        return new ActionRequestReturningNonCollection<EntityListImportResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.EntityListImportFromBytes"), EntityListImportResult.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "EntityListValidateIdentifiers")
    @JsonIgnore
    public ActionRequestReturningNonCollection<EntitiesValidateIdentifiersResult> entityListValidateIdentifiers(List<EntityIdentifier> inputsForValidation, Boolean keepDuplicates, Boolean includeParentAndUltimateParent) {
        Preconditions.checkNotNull(keepDuplicates, "keepDuplicates cannot be null");
        Preconditions.checkNotNull(includeParentAndUltimateParent, "includeParentAndUltimateParent cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputsForValidation", "Collection(ThomsonReuters.Dss.Api.Content.EntityIdentifier)", inputsForValidation)
            .put("KeepDuplicates", "Edm.Boolean", keepDuplicates)
            .put("IncludeParentAndUltimateParent", "Edm.Boolean", includeParentAndUltimateParent)
            .build();
        return new ActionRequestReturningNonCollection<EntitiesValidateIdentifiersResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.EntityListValidateIdentifiers"), EntitiesValidateIdentifiersResult.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "InstrumentListDeleteMultiple")
    @JsonIgnore
    public ActionRequestNoReturn instrumentListDeleteMultiple(List<String> listIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListIds", "Collection(Edm.String)", listIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListDeleteMultiple"), _parameters);
    }

    @Action(name = "InstrumentListDeleteAllForUser")
    @JsonIgnore
    public ActionRequestNoReturn instrumentListDeleteAllForUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListDeleteAllForUser"), _parameters);
    }

    @Action(name = "InstrumentListImportFromBytes")
    @JsonIgnore
    public ActionRequestReturningNonCollection<InstrumentListImportResult> instrumentListImportFromBytes(String fileName, byte[] fileBytes, InstrumentListImportSettings settings) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileName", "Edm.String", fileName)
            .put("FileBytes", "Edm.Binary", fileBytes)
            .put("Settings", "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings", settings)
            .build();
        return new ActionRequestReturningNonCollection<InstrumentListImportResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListImportFromBytes"), InstrumentListImportResult.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "InstrumentListValidateIdentifiers")
    @JsonIgnore
    public ActionRequestReturningNonCollection<InstrumentsValidateIdentifiersResult> instrumentListValidateIdentifiers(List<InstrumentIdentifier> inputsForValidation, Boolean keepDuplicates) {
        Preconditions.checkNotNull(keepDuplicates, "keepDuplicates cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputsForValidation", "Collection(ThomsonReuters.Dss.Api.Content.InstrumentIdentifier)", inputsForValidation)
            .put("KeepDuplicates", "Edm.Boolean", keepDuplicates)
            .build();
        return new ActionRequestReturningNonCollection<InstrumentsValidateIdentifiersResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListValidateIdentifiers"), InstrumentsValidateIdentifiersResult.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "InstrumentListValidateIdentifiersWithOptions")
    @JsonIgnore
    public ActionRequestReturningNonCollection<InstrumentsValidateIdentifiersResult> instrumentListValidateIdentifiersWithOptions(List<InstrumentIdentifier> inputsForValidation, InstrumentListValidationOptions options) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputsForValidation", "Collection(ThomsonReuters.Dss.Api.Content.InstrumentIdentifier)", inputsForValidation)
            .put("Options", "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListValidationOptions", options)
            .build();
        return new ActionRequestReturningNonCollection<InstrumentsValidateIdentifiersResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListValidateIdentifiersWithOptions"), InstrumentsValidateIdentifiersResult.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "ScheduleDeleteMultiple")
    @JsonIgnore
    public ActionRequestNoReturn scheduleDeleteMultiple(List<String> scheduleIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleIds", "Collection(Edm.String)", scheduleIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ScheduleDeleteMultiple"), _parameters);
    }

    @Action(name = "ScheduleDeleteAllForUser")
    @JsonIgnore
    public ActionRequestNoReturn scheduleDeleteAllForUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ScheduleDeleteAllForUser"), _parameters);
    }

    @Action(name = "ScheduleExtractMultipleNow")
    @JsonIgnore
    public ActionRequestNoReturn scheduleExtractMultipleNow(List<String> scheduleIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleIds", "Collection(Edm.String)", scheduleIds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ScheduleExtractMultipleNow"), _parameters);
    }

    @Action(name = "ScheduleImport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<ScheduleImportResult> scheduleImport(byte[] fileBytes, ScheduleImportSettings settings) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileBytes", "Edm.Binary", fileBytes)
            .put("Settings", "ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleImportSettings", settings)
            .build();
        return new ActionRequestReturningNonCollection<ScheduleImportResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ScheduleImport"), ScheduleImportResult.class, _parameters, thomsonreuters.dss.api.extractions.schedules.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "ReportTemplateImport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<ReportTemplatesImportResult> reportTemplateImport(byte[] fileBytes, ReportTemplateImportSettings settings) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileBytes", "Edm.Binary", fileBytes)
            .put("Settings", "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateImportSettings", settings)
            .build();
        return new ActionRequestReturningNonCollection<ReportTemplatesImportResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportTemplateImport"), ReportTemplatesImportResult.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "InstrumentSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedInstrument> instrumentSearch(IdentifierType identifierType, String identifier, List<InstrumentTypeGroup> instrumentTypeGroups, IdentifierType preferredIdentifierType, Integer maxSearchResult) {
        Preconditions.checkNotNull(identifierType, "identifierType cannot be null");
        Preconditions.checkNotNull(instrumentTypeGroups, "instrumentTypeGroups cannot be null");
        Preconditions.checkNotNull(preferredIdentifierType, "preferredIdentifierType cannot be null");
        Preconditions.checkNotNull(maxSearchResult, "maxSearchResult cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("IdentifierType", "ThomsonReuters.Dss.Api.Content.IdentifierType", identifierType)
            .put("Identifier", "Edm.String", identifier)
            .put("InstrumentTypeGroups", "Collection(ThomsonReuters.Dss.Api.Content.InstrumentTypeGroup)", instrumentTypeGroups)
            .put("PreferredIdentifierType", "ThomsonReuters.Dss.Api.Content.IdentifierType", preferredIdentifierType)
            .put("MaxSearchResult", "Edm.Int32", maxSearchResult)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentSearch"), ValidatedInstrument.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "Extract")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ExtractionRow> extract(ExtractionRequestBase extractionRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractionRequest", "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionRequestBase", extractionRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.Extract"), ExtractionRow.class, _parameters, thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "ExtractWithNotes")
    @JsonIgnore
    public ActionRequestReturningNonCollection<ExtractionResult> extractWithNotes(ExtractionRequestBase extractionRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractionRequest", "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionRequestBase", extractionRequest)
            .build();
        return new ActionRequestReturningNonCollection<ExtractionResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ExtractWithNotes"), ExtractionResult.class, _parameters, thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "ExtractRaw")
    @JsonIgnore
    public ActionRequestReturningNonCollection<RawExtractionResult> extractRaw(ExtractionRequestBase extractionRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractionRequest", "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionRequestBase", extractionRequest)
            .build();
        return new ActionRequestReturningNonCollection<RawExtractionResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ExtractRaw"), RawExtractionResult.class, _parameters, thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetOtherFiles")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OtherFile> reportExtractionGetOtherFiles() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetOtherFiles"), OtherFile.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetLastExtractionForScheduleId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<ReportExtraction> reportExtractionGetLastExtractionForScheduleId(String scheduleId) {
        Preconditions.checkNotNull(scheduleId, "scheduleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleId", "Edm.String", scheduleId)
            .build();
        return new FunctionRequestReturningNonCollection<ReportExtraction>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetLastExtractionForScheduleId"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetNextExtractionForScheduleId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<ReportExtraction> reportExtractionGetNextExtractionForScheduleId(String scheduleId) {
        Preconditions.checkNotNull(scheduleId, "scheduleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleId", "Edm.String", scheduleId)
            .build();
        return new FunctionRequestReturningNonCollection<ReportExtraction>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetNextExtractionForScheduleId"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetCompleted")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetCompleted() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetCompleted"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetPendingOrProcessing")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetPendingOrProcessing() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetPendingOrProcessing"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetCompletedByDateRange")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetCompletedByDateRange(OffsetDateTime startDate, OffsetDateTime endDate) {
        Preconditions.checkNotNull(startDate, "startDate cannot be null");
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDate", "Edm.DateTimeOffset", startDate)
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetCompletedByDateRange"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetCompletedByScheduleId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetCompletedByScheduleId(String scheduleId) {
        Preconditions.checkNotNull(scheduleId, "scheduleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleId", "Edm.String", scheduleId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetCompletedByScheduleId"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetPendingOrProcessingByScheduleId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetPendingOrProcessingByScheduleId(String scheduleId) {
        Preconditions.checkNotNull(scheduleId, "scheduleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleId", "Edm.String", scheduleId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetPendingOrProcessingByScheduleId"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetCompletedByDateRangeByScheduleId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetCompletedByDateRangeByScheduleId(String scheduleId, OffsetDateTime startDate, OffsetDateTime endDate) {
        Preconditions.checkNotNull(scheduleId, "scheduleId cannot be null");
        Preconditions.checkNotNull(startDate, "startDate cannot be null");
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleId", "Edm.String", scheduleId)
            .put("StartDate", "Edm.DateTimeOffset", startDate)
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetCompletedByDateRangeByScheduleId"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportExtractionGetByScheduleId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReportExtraction> reportExtractionGetByScheduleId(String scheduleId) {
        Preconditions.checkNotNull(scheduleId, "scheduleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleId", "Edm.String", scheduleId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportExtractionGetByScheduleId"), ReportExtraction.class, _parameters, thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "CriteriaListGetByName")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<CriteriaList> criteriaListGetByName(String listName) {
        Preconditions.checkNotNull(listName, "listName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListName", "Edm.String", listName)
            .build();
        return new FunctionRequestReturningNonCollection<CriteriaList>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListGetByName"), CriteriaList.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "CriteriaListExists")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> criteriaListExists(String listId) {
        Preconditions.checkNotNull(listId, "listId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListId", "Edm.String", listId)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListExists"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "CriteriaListGetAvailableFilters")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FilterInfo> criteriaListGetAvailableFilters(CriteriaListType criteriaListType) {
        Preconditions.checkNotNull(criteriaListType, "criteriaListType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CriteriaListType", "ThomsonReuters.Dss.Api.Extractions.SubjectLists.CriteriaListType", criteriaListType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CriteriaListGetAvailableFilters"), FilterInfo.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "EntityListExists")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> entityListExists(String entityListId) {
        Preconditions.checkNotNull(entityListId, "entityListId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityListId", "Edm.String", entityListId)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.EntityListExists"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "EntityListGetByName")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<EntityList> entityListGetByName(String listName) {
        Preconditions.checkNotNull(listName, "listName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListName", "Edm.String", listName)
            .build();
        return new FunctionRequestReturningNonCollection<EntityList>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.EntityListGetByName"), EntityList.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "InstrumentListExists")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> instrumentListExists(String listId) {
        Preconditions.checkNotNull(listId, "listId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListId", "Edm.String", listId)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListExists"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "InstrumentListGetByName")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<InstrumentList> instrumentListGetByName(String listName) {
        Preconditions.checkNotNull(listName, "listName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ListName", "Edm.String", listName)
            .build();
        return new FunctionRequestReturningNonCollection<InstrumentList>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.InstrumentListGetByName"), InstrumentList.class, _parameters, thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ScheduleGetByName")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Schedule> scheduleGetByName(String scheduleName) {
        Preconditions.checkNotNull(scheduleName, "scheduleName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ScheduleName", "Edm.String", scheduleName)
            .build();
        return new FunctionRequestReturningNonCollection<Schedule>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ScheduleGetByName"), Schedule.class, _parameters, thomsonreuters.dss.api.extractions.schedules.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ScheduleGetInstrumentTriggerDetails")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InstrumentTriggerDetail> scheduleGetInstrumentTriggerDetails(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Id", "Edm.String", id)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ScheduleGetInstrumentTriggerDetails"), InstrumentTriggerDetail.class, _parameters, thomsonreuters.dss.api.extractions.schedules.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportTemplateGetContentFieldsByReportTemplateId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentField> reportTemplateGetContentFieldsByReportTemplateId(String reportTemplateId) {
        Preconditions.checkNotNull(reportTemplateId, "reportTemplateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportTemplateId", "Edm.String", reportTemplateId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportTemplateGetContentFieldsByReportTemplateId"), ContentField.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ReportTemplateGetByName")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<ReportTemplate> reportTemplateGetByName(String name) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Name", "Edm.String", name)
            .build();
        return new FunctionRequestReturningNonCollection<ReportTemplate>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ReportTemplateGetByName"), ReportTemplate.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "BondScheduleReportTemplateGetBondScheduleTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<BondScheduleType> bondScheduleReportTemplateGetBondScheduleTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.BondScheduleReportTemplateGetBondScheduleTypes"), BondScheduleType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "CorporateActionsIpoReportTemplateGetExchangeTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ExchangeType> corporateActionsIpoReportTemplateGetExchangeTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.CorporateActionsIpoReportTemplateGetExchangeTypes"), ExchangeType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsAnalyticsCommoditiesReportTemplateGetNewsAttributionTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsAttributionType> newsAnalyticsCommoditiesReportTemplateGetNewsAttributionTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsAnalyticsCommoditiesReportTemplateGetNewsAttributionTypes"), NewsAttributionType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsAnalyticsCommoditiesReportTemplateGetNewsTopicTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsTopicType> newsAnalyticsCommoditiesReportTemplateGetNewsTopicTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsAnalyticsCommoditiesReportTemplateGetNewsTopicTypes"), NewsTopicType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsAnalyticsCommoditiesReportTemplateGetNewsCommodityTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsCommodityType> newsAnalyticsCommoditiesReportTemplateGetNewsCommodityTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsAnalyticsCommoditiesReportTemplateGetNewsCommodityTypes"), NewsCommodityType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsItemsReportTemplateGetNewsAttributionTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsAttributionType> newsItemsReportTemplateGetNewsAttributionTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsItemsReportTemplateGetNewsAttributionTypes"), NewsAttributionType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsItemsReportTemplateGetNewsTopicTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsTopicType> newsItemsReportTemplateGetNewsTopicTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsItemsReportTemplateGetNewsTopicTypes"), NewsTopicType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsItemsReportTemplateGetNewsItemsLanguageTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsLanguageType> newsItemsReportTemplateGetNewsItemsLanguageTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsItemsReportTemplateGetNewsItemsLanguageTypes"), NewsLanguageType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "RatingsReportTemplateGetRatingsSourceTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RatingSourceType> ratingsReportTemplateGetRatingsSourceTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.RatingsReportTemplateGetRatingsSourceTypes"), RatingSourceType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsAnalyticsReportTemplateGetNewsAttributionTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsAttributionType> newsAnalyticsReportTemplateGetNewsAttributionTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsAnalyticsReportTemplateGetNewsAttributionTypes"), NewsAttributionType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "NewsAnalyticsReportTemplateGetNewsTopicTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<NewsTopicType> newsAnalyticsReportTemplateGetNewsTopicTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.NewsAnalyticsReportTemplateGetNewsTopicTypes"), NewsTopicType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "TimeSeriesReportTemplateGetLookBackPeriods")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ExtractionConditionSelectionItem> timeSeriesReportTemplateGetLookBackPeriods() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.TimeSeriesReportTemplateGetLookBackPeriods"), ExtractionConditionSelectionItem.class, _parameters, thomsonreuters.dss.api.extractions.extractionconditions.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ExtractResult")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ExtractionRow> extractResult(String extractionId) {
        Preconditions.checkNotNull(extractionId, "extractionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractionId", "Edm.String", extractionId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ExtractResult"), ExtractionRow.class, _parameters, thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ExtractWithNotesResult")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<ExtractionResult> extractWithNotesResult(String extractionId) {
        Preconditions.checkNotNull(extractionId, "extractionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractionId", "Edm.String", extractionId)
            .build();
        return new FunctionRequestReturningNonCollection<ExtractionResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ExtractWithNotesResult"), ExtractionResult.class, _parameters, thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "ExtractRawResult")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<RawExtractionResult> extractRawResult(String extractionId) {
        Preconditions.checkNotNull(extractionId, "extractionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExtractionId", "Edm.String", extractionId)
            .build();
        return new FunctionRequestReturningNonCollection<RawExtractionResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.ExtractRawResult"), RawExtractionResult.class, _parameters, thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetValidExtractionFieldNames")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getValidExtractionFieldNames(thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportTemplateTypes reportTemplateType) {
        Preconditions.checkNotNull(reportTemplateType, "reportTemplateType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportTemplateType", "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateTypes", reportTemplateType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.GetValidExtractionFieldNames"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "GetValidExtractionFieldNamesForTemplateCode")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getValidExtractionFieldNamesForTemplateCode(String reportTemplateCode) {
        Preconditions.checkNotNull(reportTemplateCode, "reportTemplateCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportTemplateCode", "Edm.String", reportTemplateCode)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.GetValidExtractionFieldNamesForTemplateCode"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "GetValidContentFieldTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentFieldType> getValidContentFieldTypes(thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportTemplateTypes reportTemplateType) {
        Preconditions.checkNotNull(reportTemplateType, "reportTemplateType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportTemplateType", "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateTypes", reportTemplateType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.GetValidContentFieldTypes"), ContentFieldType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetValidContentFieldTypesForTemplateCode")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentFieldType> getValidContentFieldTypesForTemplateCode(String reportTemplateCode) {
        Preconditions.checkNotNull(reportTemplateCode, "reportTemplateCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportTemplateCode", "Edm.String", reportTemplateCode)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.GetValidContentFieldTypesForTemplateCode"), ContentFieldType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetValidContentFieldTypesForClass")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentFieldType> getValidContentFieldTypesForClass(String reportTemplateOrExtractRequestClassName) {
        Preconditions.checkNotNull(reportTemplateOrExtractRequestClassName, "reportTemplateOrExtractRequestClassName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportTemplateOrExtractRequestClassName", "Edm.String", reportTemplateOrExtractRequestClassName)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.GetValidContentFieldTypesForClass"), ContentFieldType.class, _parameters, thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalFidDefinitions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalFidDefinitions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Extractions.GetHistoricalFidDefinitions"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

}
