package thomsonreuters.dss.api.extractions.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Code", 
    "Name", 
    "Description"})
public class TypeBase implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.TypeBase";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Code")
    protected String code;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("Description")
    protected String description;

    protected TypeBase() {
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && code != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(code.toString()));
        }
    }

    @Property(name="Code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public TypeBase withCode(String code) {
        TypeBase _x = _copy();
        _x.changedFields = changedFields.add("Code");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.TypeBase");
        _x.code = code;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public TypeBase withName(String name) {
        TypeBase _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.TypeBase");
        _x.name = name;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TypeBase withDescription(String description) {
        TypeBase _x = _copy();
        _x.changedFields = changedFields.add("Description");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.TypeBase");
        _x.description = description;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TypeBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TypeBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TypeBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TypeBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TypeBase _copy() {
        TypeBase _x = new TypeBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.name = name;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TypeBase[");
        b.append("Code=");
        b.append(this.code);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
