package thomsonreuters.dss.api.extractions.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import thomsonreuters.dss.api.extractions.entity.set.ReportExtractions;
import thomsonreuters.dss.api.extractions.entity.set.ReportTemplates;
import thomsonreuters.dss.api.extractions.schedules.collection.request.ScheduleCollectionRequest;

public final class Schedules extends ScheduleCollectionRequest {

    public Schedules(ContextPath contextPath) {
        super(contextPath);
    }

    public ReportTemplates reportTemplate() {
        return new ReportTemplates(contextPath.addSegment("ReportTemplate"));
    }

    public ReportExtractions pendingExtractions() {
        return new ReportExtractions(contextPath.addSegment("PendingExtractions"));
    }

    public ReportExtractions completedExtractions() {
        return new ReportExtractions(contextPath.addSegment("CompletedExtractions"));
    }

    public ReportExtractions lastExtraction() {
        return new ReportExtractions(contextPath.addSegment("LastExtraction"));
    }

    public ReportExtractions nextExtraction() {
        return new ReportExtractions(contextPath.addSegment("NextExtraction"));
    }
}
