package thomsonreuters.dss.api.extractions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ImportActionEnum implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Add")
    ADD("Add", "1"),

    @JsonProperty("Append")
    APPEND("Append", "2"),

    @JsonProperty("Replace")
    REPLACE("Replace", "3");

    private final String name;
    private final String value;

    private ImportActionEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
