package thomsonreuters.dss.api.extractions.extractionconditions.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import thomsonreuters.dss.api.extractions.entity.TypeBase;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type"})
public class ExtractionConditionSelectionItem extends TypeBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionConditions.ExtractionConditionSelectionItem";
    }

    protected ExtractionConditionSelectionItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExtractionConditionSelectionItem() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private String name;
        private String description;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("Code");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public ExtractionConditionSelectionItem build() {
            ExtractionConditionSelectionItem _x = new ExtractionConditionSelectionItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionConditions.ExtractionConditionSelectionItem";
            _x.code = code;
            _x.name = name;
            _x.description = description;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && code != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(code.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExtractionConditionSelectionItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExtractionConditionSelectionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExtractionConditionSelectionItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExtractionConditionSelectionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExtractionConditionSelectionItem _copy() {
        ExtractionConditionSelectionItem _x = new ExtractionConditionSelectionItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.name = name;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractionConditionSelectionItem[");
        b.append("Code=");
        b.append(this.code);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
