package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRequestBase;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CorporateActionsIpoCondition;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ContentFieldNames", 
    "Condition"})
public class CorporateActionsIpoExtractionRequest extends ExtractionRequestBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ContentFieldNames")
    protected List<String> contentFieldNames;

    @JsonProperty("ContentFieldNames@nextLink")
    protected String contentFieldNamesNextLink;

    @JsonProperty("Condition")
    protected CorporateActionsIpoCondition condition;

    protected CorporateActionsIpoExtractionRequest() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIpoExtractionRequest";
    }

    @Property(name="ContentFieldNames")
    @JsonIgnore
    public CollectionPage<String> getContentFieldNames() {
        return new CollectionPage<String>(contextPath, String.class, contentFieldNames, Optional.ofNullable(contentFieldNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Condition")
    @JsonIgnore
    public Optional<CorporateActionsIpoCondition> getCondition() {
        return Optional.ofNullable(condition);
    }

    public CorporateActionsIpoExtractionRequest withCondition(CorporateActionsIpoCondition condition) {
        CorporateActionsIpoExtractionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIpoExtractionRequest");
        _x.condition = condition;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCorporateActionsIpoExtractionRequest() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> contentFieldNames;
        private String contentFieldNamesNextLink;
        private CorporateActionsIpoCondition condition;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder contentFieldNames(List<String> contentFieldNames) {
            this.contentFieldNames = contentFieldNames;
            this.changedFields = changedFields.add("ContentFieldNames");
            return this;
        }

        public Builder contentFieldNamesNextLink(String contentFieldNamesNextLink) {
            this.contentFieldNamesNextLink = contentFieldNamesNextLink;
            this.changedFields = changedFields.add("ContentFieldNames");
            return this;
        }

        public Builder condition(CorporateActionsIpoCondition condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("Condition");
            return this;
        }

        public CorporateActionsIpoExtractionRequest build() {
            CorporateActionsIpoExtractionRequest _x = new CorporateActionsIpoExtractionRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIpoExtractionRequest";
            _x.contentFieldNames = contentFieldNames;
            _x.contentFieldNamesNextLink = contentFieldNamesNextLink;
            _x.condition = condition;
            return _x;
        }
    }

    private CorporateActionsIpoExtractionRequest _copy() {
        CorporateActionsIpoExtractionRequest _x = new CorporateActionsIpoExtractionRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.contentFieldNames = contentFieldNames;
        _x.condition = condition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CorporateActionsIpoExtractionRequest[");
        b.append("ContentFieldNames=");
        b.append(this.contentFieldNames);
        b.append(", ");
        b.append("Condition=");
        b.append(this.condition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
