package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRequestBase;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierListBase;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CorporateActionsIsoCondition;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Condition", 
    "IdentifierList"})
public class CorporateActionsIsoExtractionRequest extends ExtractionRequestBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Condition")
    protected CorporateActionsIsoCondition condition;

    @JsonProperty("IdentifierList")
    protected InstrumentIdentifierListBase identifierList;

    protected CorporateActionsIsoExtractionRequest() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIsoExtractionRequest";
    }

    @Property(name="Condition")
    @JsonIgnore
    public Optional<CorporateActionsIsoCondition> getCondition() {
        return Optional.ofNullable(condition);
    }

    public CorporateActionsIsoExtractionRequest withCondition(CorporateActionsIsoCondition condition) {
        CorporateActionsIsoExtractionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIsoExtractionRequest");
        _x.condition = condition;
        return _x;
    }

    @Property(name="IdentifierList")
    @JsonIgnore
    public Optional<InstrumentIdentifierListBase> getIdentifierList() {
        return Optional.ofNullable(identifierList);
    }

    public CorporateActionsIsoExtractionRequest withIdentifierList(InstrumentIdentifierListBase identifierList) {
        CorporateActionsIsoExtractionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIsoExtractionRequest");
        _x.identifierList = identifierList;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCorporateActionsIsoExtractionRequest() {
        return new Builder();
    }

    public static final class Builder {
        private CorporateActionsIsoCondition condition;
        private InstrumentIdentifierListBase identifierList;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder condition(CorporateActionsIsoCondition condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("Condition");
            return this;
        }

        public Builder identifierList(InstrumentIdentifierListBase identifierList) {
            this.identifierList = identifierList;
            this.changedFields = changedFields.add("IdentifierList");
            return this;
        }

        public CorporateActionsIsoExtractionRequest build() {
            CorporateActionsIsoExtractionRequest _x = new CorporateActionsIsoExtractionRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIsoExtractionRequest";
            _x.condition = condition;
            _x.identifierList = identifierList;
            return _x;
        }
    }

    private CorporateActionsIsoExtractionRequest _copy() {
        CorporateActionsIsoExtractionRequest _x = new CorporateActionsIsoExtractionRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.condition = condition;
        _x.identifierList = identifierList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CorporateActionsIsoExtractionRequest[");
        b.append("Condition=");
        b.append(this.condition);
        b.append(", ");
        b.append("IdentifierList=");
        b.append(this.identifierList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
