package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.complex.HourMinute;
import thomsonreuters.dss.api.extractions.extractionrequests.enums.TriggerTimeoutDay;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EndOfDayPricingReportCondition;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "LimitReportToTodaysData", 
    "IsErrorCorrected", 
    "IsDelta", 
    "TriggerTimeoutUserTime", 
    "TriggerTimeoutDayOffset"})
public class EndOfDayPricingCondition extends EndOfDayPricingReportCondition implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("LimitReportToTodaysData")
    protected Boolean limitReportToTodaysData;

    @JsonProperty("IsErrorCorrected")
    protected Boolean isErrorCorrected;

    @JsonProperty("IsDelta")
    protected Boolean isDelta;

    @JsonProperty("TriggerTimeoutUserTime")
    protected HourMinute triggerTimeoutUserTime;

    @JsonProperty("TriggerTimeoutDayOffset")
    protected TriggerTimeoutDay triggerTimeoutDayOffset;

    protected EndOfDayPricingCondition() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition";
    }

    @Property(name="LimitReportToTodaysData")
    @JsonIgnore
    public Optional<Boolean> getLimitReportToTodaysData() {
        return Optional.ofNullable(limitReportToTodaysData);
    }

    public EndOfDayPricingCondition withLimitReportToTodaysData(Boolean limitReportToTodaysData) {
        EndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition");
        _x.limitReportToTodaysData = limitReportToTodaysData;
        return _x;
    }

    @Property(name="IsErrorCorrected")
    @JsonIgnore
    public Optional<Boolean> getIsErrorCorrected() {
        return Optional.ofNullable(isErrorCorrected);
    }

    public EndOfDayPricingCondition withIsErrorCorrected(Boolean isErrorCorrected) {
        EndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition");
        _x.isErrorCorrected = isErrorCorrected;
        return _x;
    }

    @Property(name="IsDelta")
    @JsonIgnore
    public Optional<Boolean> getIsDelta() {
        return Optional.ofNullable(isDelta);
    }

    public EndOfDayPricingCondition withIsDelta(Boolean isDelta) {
        EndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition");
        _x.isDelta = isDelta;
        return _x;
    }

    @Property(name="TriggerTimeoutUserTime")
    @JsonIgnore
    public Optional<HourMinute> getTriggerTimeoutUserTime() {
        return Optional.ofNullable(triggerTimeoutUserTime);
    }

    public EndOfDayPricingCondition withTriggerTimeoutUserTime(HourMinute triggerTimeoutUserTime) {
        EndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition");
        _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
        return _x;
    }

    @Property(name="TriggerTimeoutDayOffset")
    @JsonIgnore
    public Optional<TriggerTimeoutDay> getTriggerTimeoutDayOffset() {
        return Optional.ofNullable(triggerTimeoutDayOffset);
    }

    public EndOfDayPricingCondition withTriggerTimeoutDayOffset(TriggerTimeoutDay triggerTimeoutDayOffset) {
        EndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition");
        _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEndOfDayPricingCondition() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean scalableCurrency;
        private Boolean limitReportToTodaysData;
        private Boolean isErrorCorrected;
        private Boolean isDelta;
        private HourMinute triggerTimeoutUserTime;
        private TriggerTimeoutDay triggerTimeoutDayOffset;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder scalableCurrency(Boolean scalableCurrency) {
            this.scalableCurrency = scalableCurrency;
            this.changedFields = changedFields.add("ScalableCurrency");
            return this;
        }

        public Builder limitReportToTodaysData(Boolean limitReportToTodaysData) {
            this.limitReportToTodaysData = limitReportToTodaysData;
            this.changedFields = changedFields.add("LimitReportToTodaysData");
            return this;
        }

        public Builder isErrorCorrected(Boolean isErrorCorrected) {
            this.isErrorCorrected = isErrorCorrected;
            this.changedFields = changedFields.add("IsErrorCorrected");
            return this;
        }

        public Builder isDelta(Boolean isDelta) {
            this.isDelta = isDelta;
            this.changedFields = changedFields.add("IsDelta");
            return this;
        }

        public Builder triggerTimeoutUserTime(HourMinute triggerTimeoutUserTime) {
            this.triggerTimeoutUserTime = triggerTimeoutUserTime;
            this.changedFields = changedFields.add("TriggerTimeoutUserTime");
            return this;
        }

        public Builder triggerTimeoutDayOffset(TriggerTimeoutDay triggerTimeoutDayOffset) {
            this.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
            this.changedFields = changedFields.add("TriggerTimeoutDayOffset");
            return this;
        }

        public EndOfDayPricingCondition build() {
            EndOfDayPricingCondition _x = new EndOfDayPricingCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition";
            _x.scalableCurrency = scalableCurrency;
            _x.limitReportToTodaysData = limitReportToTodaysData;
            _x.isErrorCorrected = isErrorCorrected;
            _x.isDelta = isDelta;
            _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
            _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
            return _x;
        }
    }

    private EndOfDayPricingCondition _copy() {
        EndOfDayPricingCondition _x = new EndOfDayPricingCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.scalableCurrency = scalableCurrency;
        _x.limitReportToTodaysData = limitReportToTodaysData;
        _x.isErrorCorrected = isErrorCorrected;
        _x.isDelta = isDelta;
        _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
        _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EndOfDayPricingCondition[");
        b.append("ScalableCurrency=");
        b.append(this.scalableCurrency);
        b.append(", ");
        b.append("LimitReportToTodaysData=");
        b.append(this.limitReportToTodaysData);
        b.append(", ");
        b.append("IsErrorCorrected=");
        b.append(this.isErrorCorrected);
        b.append(", ");
        b.append("IsDelta=");
        b.append(this.isDelta);
        b.append(", ");
        b.append("TriggerTimeoutUserTime=");
        b.append(this.triggerTimeoutUserTime);
        b.append(", ");
        b.append("TriggerTimeoutDayOffset=");
        b.append(this.triggerTimeoutDayOffset);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
