package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.EntityIdentifier;
import thomsonreuters.dss.api.content.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EntityIdentifierListBase;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "EntityIdentifiers"})
public class EntityIdentifierList extends EntityIdentifierListBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("EntityIdentifiers")
    protected List<EntityIdentifier> entityIdentifiers;

    @JsonProperty("EntityIdentifiers@nextLink")
    protected String entityIdentifiersNextLink;

    protected EntityIdentifierList() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EntityIdentifierList";
    }

    @Property(name="EntityIdentifiers")
    @JsonIgnore
    public CollectionPage<EntityIdentifier> getEntityIdentifiers() {
        return new CollectionPage<EntityIdentifier>(contextPath, EntityIdentifier.class, entityIdentifiers, Optional.ofNullable(entityIdentifiersNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntityIdentifierList() {
        return new Builder();
    }

    public static final class Builder {
        private List<EntityIdentifier> entityIdentifiers;
        private String entityIdentifiersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entityIdentifiers(List<EntityIdentifier> entityIdentifiers) {
            this.entityIdentifiers = entityIdentifiers;
            this.changedFields = changedFields.add("EntityIdentifiers");
            return this;
        }

        public Builder entityIdentifiersNextLink(String entityIdentifiersNextLink) {
            this.entityIdentifiersNextLink = entityIdentifiersNextLink;
            this.changedFields = changedFields.add("EntityIdentifiers");
            return this;
        }

        public EntityIdentifierList build() {
            EntityIdentifierList _x = new EntityIdentifierList();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EntityIdentifierList";
            _x.entityIdentifiers = entityIdentifiers;
            _x.entityIdentifiersNextLink = entityIdentifiersNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityIdentifierList[");
        b.append("EntityIdentifiers=");
        b.append(this.entityIdentifiers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
