package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRow;
import thomsonreuters.dss.api.extractions.extractionrequests.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Contents", 
    "Notes"})
public class ExtractionResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Contents")
    protected List<ExtractionRow> contents;

    @JsonProperty("Contents@nextLink")
    protected String contentsNextLink;

    @JsonProperty("Notes")
    protected List<String> notes;

    @JsonProperty("Notes@nextLink")
    protected String notesNextLink;

    protected ExtractionResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionResult";
    }

    @Property(name="Contents")
    @JsonIgnore
    public CollectionPage<ExtractionRow> getContents() {
        return new CollectionPage<ExtractionRow>(contextPath, ExtractionRow.class, contents, Optional.ofNullable(contentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Notes")
    @JsonIgnore
    public CollectionPage<String> getNotes() {
        return new CollectionPage<String>(contextPath, String.class, notes, Optional.ofNullable(notesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ExtractionRow> contents;
        private String contentsNextLink;
        private List<String> notes;
        private String notesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder contents(List<ExtractionRow> contents) {
            this.contents = contents;
            this.changedFields = changedFields.add("Contents");
            return this;
        }

        public Builder contentsNextLink(String contentsNextLink) {
            this.contentsNextLink = contentsNextLink;
            this.changedFields = changedFields.add("Contents");
            return this;
        }

        public Builder notes(List<String> notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("Notes");
            return this;
        }

        public Builder notesNextLink(String notesNextLink) {
            this.notesNextLink = notesNextLink;
            this.changedFields = changedFields.add("Notes");
            return this;
        }

        public ExtractionResult build() {
            ExtractionResult _x = new ExtractionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionResult";
            _x.contents = contents;
            _x.contentsNextLink = contentsNextLink;
            _x.notes = notes;
            _x.notesNextLink = notesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractionResult[");
        b.append("Contents=");
        b.append(this.contents);
        b.append(", ");
        b.append("Notes=");
        b.append(this.notes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
