package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierListBase;
import thomsonreuters.dss.api.extractions.subjectlists.complex.CriteriaListFilter;
import thomsonreuters.dss.api.extractions.subjectlists.enums.CriteriaListType;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Filters", 
    "Type"})
public class InstrumentCriteriaList extends InstrumentIdentifierListBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Filters")
    protected List<CriteriaListFilter> filters;

    @JsonProperty("Filters@nextLink")
    protected String filtersNextLink;

    @JsonProperty("Type")
    protected CriteriaListType type;

    protected InstrumentCriteriaList() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentCriteriaList";
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<CriteriaListFilter> getFilters() {
        return new CollectionPage<CriteriaListFilter>(contextPath, CriteriaListFilter.class, filters, Optional.ofNullable(filtersNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<CriteriaListType> getType() {
        return Optional.ofNullable(type);
    }

    public InstrumentCriteriaList withType(CriteriaListType type) {
        InstrumentCriteriaList _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentCriteriaList");
        _x.type = type;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInstrumentCriteriaList() {
        return new Builder();
    }

    public static final class Builder {
        private List<CriteriaListFilter> filters;
        private String filtersNextLink;
        private CriteriaListType type;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder filters(List<CriteriaListFilter> filters) {
            this.filters = filters;
            this.changedFields = changedFields.add("Filters");
            return this;
        }

        public Builder filtersNextLink(String filtersNextLink) {
            this.filtersNextLink = filtersNextLink;
            this.changedFields = changedFields.add("Filters");
            return this;
        }

        public Builder type(CriteriaListType type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public InstrumentCriteriaList build() {
            InstrumentCriteriaList _x = new InstrumentCriteriaList();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentCriteriaList";
            _x.filters = filters;
            _x.filtersNextLink = filtersNextLink;
            _x.type = type;
            return _x;
        }
    }

    private InstrumentCriteriaList _copy() {
        InstrumentCriteriaList _x = new InstrumentCriteriaList();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.filters = filters;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentCriteriaList[");
        b.append("Filters=");
        b.append(this.filters);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
