package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.InstrumentIdentifier;
import thomsonreuters.dss.api.content.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierListBase;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentValidationOptions;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "InstrumentIdentifiers", 
    "ValidationOptions", 
    "UseUserPreferencesForValidationOptions"})
public class InstrumentIdentifierList extends InstrumentIdentifierListBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("InstrumentIdentifiers")
    protected List<InstrumentIdentifier> instrumentIdentifiers;

    @JsonProperty("InstrumentIdentifiers@nextLink")
    protected String instrumentIdentifiersNextLink;

    @JsonProperty("ValidationOptions")
    protected InstrumentValidationOptions validationOptions;

    @JsonProperty("UseUserPreferencesForValidationOptions")
    protected Boolean useUserPreferencesForValidationOptions;

    protected InstrumentIdentifierList() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentIdentifierList";
    }

    @Property(name="InstrumentIdentifiers")
    @JsonIgnore
    public CollectionPage<InstrumentIdentifier> getInstrumentIdentifiers() {
        return new CollectionPage<InstrumentIdentifier>(contextPath, InstrumentIdentifier.class, instrumentIdentifiers, Optional.ofNullable(instrumentIdentifiersNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ValidationOptions")
    @JsonIgnore
    public Optional<InstrumentValidationOptions> getValidationOptions() {
        return Optional.ofNullable(validationOptions);
    }

    public InstrumentIdentifierList withValidationOptions(InstrumentValidationOptions validationOptions) {
        InstrumentIdentifierList _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentIdentifierList");
        _x.validationOptions = validationOptions;
        return _x;
    }

    @Property(name="UseUserPreferencesForValidationOptions")
    @JsonIgnore
    public Optional<Boolean> getUseUserPreferencesForValidationOptions() {
        return Optional.ofNullable(useUserPreferencesForValidationOptions);
    }

    public InstrumentIdentifierList withUseUserPreferencesForValidationOptions(Boolean useUserPreferencesForValidationOptions) {
        InstrumentIdentifierList _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentIdentifierList");
        _x.useUserPreferencesForValidationOptions = useUserPreferencesForValidationOptions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInstrumentIdentifierList() {
        return new Builder();
    }

    public static final class Builder {
        private List<InstrumentIdentifier> instrumentIdentifiers;
        private String instrumentIdentifiersNextLink;
        private InstrumentValidationOptions validationOptions;
        private Boolean useUserPreferencesForValidationOptions;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder instrumentIdentifiers(List<InstrumentIdentifier> instrumentIdentifiers) {
            this.instrumentIdentifiers = instrumentIdentifiers;
            this.changedFields = changedFields.add("InstrumentIdentifiers");
            return this;
        }

        public Builder instrumentIdentifiersNextLink(String instrumentIdentifiersNextLink) {
            this.instrumentIdentifiersNextLink = instrumentIdentifiersNextLink;
            this.changedFields = changedFields.add("InstrumentIdentifiers");
            return this;
        }

        public Builder validationOptions(InstrumentValidationOptions validationOptions) {
            this.validationOptions = validationOptions;
            this.changedFields = changedFields.add("ValidationOptions");
            return this;
        }

        public Builder useUserPreferencesForValidationOptions(Boolean useUserPreferencesForValidationOptions) {
            this.useUserPreferencesForValidationOptions = useUserPreferencesForValidationOptions;
            this.changedFields = changedFields.add("UseUserPreferencesForValidationOptions");
            return this;
        }

        public InstrumentIdentifierList build() {
            InstrumentIdentifierList _x = new InstrumentIdentifierList();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentIdentifierList";
            _x.instrumentIdentifiers = instrumentIdentifiers;
            _x.instrumentIdentifiersNextLink = instrumentIdentifiersNextLink;
            _x.validationOptions = validationOptions;
            _x.useUserPreferencesForValidationOptions = useUserPreferencesForValidationOptions;
            return _x;
        }
    }

    private InstrumentIdentifierList _copy() {
        InstrumentIdentifierList _x = new InstrumentIdentifierList();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.instrumentIdentifiers = instrumentIdentifiers;
        _x.validationOptions = validationOptions;
        _x.useUserPreferencesForValidationOptions = useUserPreferencesForValidationOptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentIdentifierList[");
        b.append("InstrumentIdentifiers=");
        b.append(this.instrumentIdentifiers);
        b.append(", ");
        b.append("ValidationOptions=");
        b.append(this.validationOptions);
        b.append(", ");
        b.append("UseUserPreferencesForValidationOptions=");
        b.append(this.useUserPreferencesForValidationOptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
