package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierListBase;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "InstrumentListId"})
public class InstrumentListIdentifierList extends InstrumentIdentifierListBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("InstrumentListId")
    protected String instrumentListId;

    protected InstrumentListIdentifierList() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentListIdentifierList";
    }

    @Property(name="InstrumentListId")
    @JsonIgnore
    public Optional<String> getInstrumentListId() {
        return Optional.ofNullable(instrumentListId);
    }

    public InstrumentListIdentifierList withInstrumentListId(String instrumentListId) {
        InstrumentListIdentifierList _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentListIdentifierList");
        _x.instrumentListId = instrumentListId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInstrumentListIdentifierList() {
        return new Builder();
    }

    public static final class Builder {
        private String instrumentListId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder instrumentListId(String instrumentListId) {
            this.instrumentListId = instrumentListId;
            this.changedFields = changedFields.add("InstrumentListId");
            return this;
        }

        public InstrumentListIdentifierList build() {
            InstrumentListIdentifierList _x = new InstrumentListIdentifierList();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentListIdentifierList";
            _x.instrumentListId = instrumentListId;
            return _x;
        }
    }

    private InstrumentListIdentifierList _copy() {
        InstrumentListIdentifierList _x = new InstrumentListIdentifierList();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.instrumentListId = instrumentListId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentListIdentifierList[");
        b.append("InstrumentListId=");
        b.append(this.instrumentListId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
