package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.complex.HourMinute;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "LimitReportToTodaysData", 
    "IsErrorCorrected", 
    "IsDelta", 
    "TriggerTimeoutUserTime", 
    "TriggerTimeoutDayOffset", 
    "UseRelativeAnalytics"})
public class TechnicalIndicatorsCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LimitReportToTodaysData")
    protected Boolean limitReportToTodaysData;

    @JsonProperty("IsErrorCorrected")
    protected Boolean isErrorCorrected;

    @JsonProperty("IsDelta")
    protected Boolean isDelta;

    @JsonProperty("TriggerTimeoutUserTime")
    protected HourMinute triggerTimeoutUserTime;

    @JsonProperty("TriggerTimeoutDayOffset")
    protected Integer triggerTimeoutDayOffset;

    @JsonProperty("UseRelativeAnalytics")
    protected Boolean useRelativeAnalytics;

    protected TechnicalIndicatorsCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition";
    }

    @Property(name="LimitReportToTodaysData")
    @JsonIgnore
    public Optional<Boolean> getLimitReportToTodaysData() {
        return Optional.ofNullable(limitReportToTodaysData);
    }

    public TechnicalIndicatorsCondition withLimitReportToTodaysData(Boolean limitReportToTodaysData) {
        TechnicalIndicatorsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition");
        _x.limitReportToTodaysData = limitReportToTodaysData;
        return _x;
    }

    @Property(name="IsErrorCorrected")
    @JsonIgnore
    public Optional<Boolean> getIsErrorCorrected() {
        return Optional.ofNullable(isErrorCorrected);
    }

    public TechnicalIndicatorsCondition withIsErrorCorrected(Boolean isErrorCorrected) {
        TechnicalIndicatorsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition");
        _x.isErrorCorrected = isErrorCorrected;
        return _x;
    }

    @Property(name="IsDelta")
    @JsonIgnore
    public Optional<Boolean> getIsDelta() {
        return Optional.ofNullable(isDelta);
    }

    public TechnicalIndicatorsCondition withIsDelta(Boolean isDelta) {
        TechnicalIndicatorsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition");
        _x.isDelta = isDelta;
        return _x;
    }

    @Property(name="TriggerTimeoutUserTime")
    @JsonIgnore
    public Optional<HourMinute> getTriggerTimeoutUserTime() {
        return Optional.ofNullable(triggerTimeoutUserTime);
    }

    public TechnicalIndicatorsCondition withTriggerTimeoutUserTime(HourMinute triggerTimeoutUserTime) {
        TechnicalIndicatorsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition");
        _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
        return _x;
    }

    @Property(name="TriggerTimeoutDayOffset")
    @JsonIgnore
    public Optional<Integer> getTriggerTimeoutDayOffset() {
        return Optional.ofNullable(triggerTimeoutDayOffset);
    }

    public TechnicalIndicatorsCondition withTriggerTimeoutDayOffset(Integer triggerTimeoutDayOffset) {
        TechnicalIndicatorsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition");
        _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
        return _x;
    }

    @Property(name="UseRelativeAnalytics")
    @JsonIgnore
    public Optional<Boolean> getUseRelativeAnalytics() {
        return Optional.ofNullable(useRelativeAnalytics);
    }

    public TechnicalIndicatorsCondition withUseRelativeAnalytics(Boolean useRelativeAnalytics) {
        TechnicalIndicatorsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition");
        _x.useRelativeAnalytics = useRelativeAnalytics;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean limitReportToTodaysData;
        private Boolean isErrorCorrected;
        private Boolean isDelta;
        private HourMinute triggerTimeoutUserTime;
        private Integer triggerTimeoutDayOffset;
        private Boolean useRelativeAnalytics;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder limitReportToTodaysData(Boolean limitReportToTodaysData) {
            this.limitReportToTodaysData = limitReportToTodaysData;
            this.changedFields = changedFields.add("LimitReportToTodaysData");
            return this;
        }

        public Builder isErrorCorrected(Boolean isErrorCorrected) {
            this.isErrorCorrected = isErrorCorrected;
            this.changedFields = changedFields.add("IsErrorCorrected");
            return this;
        }

        public Builder isDelta(Boolean isDelta) {
            this.isDelta = isDelta;
            this.changedFields = changedFields.add("IsDelta");
            return this;
        }

        public Builder triggerTimeoutUserTime(HourMinute triggerTimeoutUserTime) {
            this.triggerTimeoutUserTime = triggerTimeoutUserTime;
            this.changedFields = changedFields.add("TriggerTimeoutUserTime");
            return this;
        }

        public Builder triggerTimeoutDayOffset(Integer triggerTimeoutDayOffset) {
            this.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
            this.changedFields = changedFields.add("TriggerTimeoutDayOffset");
            return this;
        }

        public Builder useRelativeAnalytics(Boolean useRelativeAnalytics) {
            this.useRelativeAnalytics = useRelativeAnalytics;
            this.changedFields = changedFields.add("UseRelativeAnalytics");
            return this;
        }

        public TechnicalIndicatorsCondition build() {
            TechnicalIndicatorsCondition _x = new TechnicalIndicatorsCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition";
            _x.limitReportToTodaysData = limitReportToTodaysData;
            _x.isErrorCorrected = isErrorCorrected;
            _x.isDelta = isDelta;
            _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
            _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
            _x.useRelativeAnalytics = useRelativeAnalytics;
            return _x;
        }
    }

    private TechnicalIndicatorsCondition _copy() {
        TechnicalIndicatorsCondition _x = new TechnicalIndicatorsCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.limitReportToTodaysData = limitReportToTodaysData;
        _x.isErrorCorrected = isErrorCorrected;
        _x.isDelta = isDelta;
        _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
        _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
        _x.useRelativeAnalytics = useRelativeAnalytics;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TechnicalIndicatorsCondition[");
        b.append("LimitReportToTodaysData=");
        b.append(this.limitReportToTodaysData);
        b.append(", ");
        b.append("IsErrorCorrected=");
        b.append(this.isErrorCorrected);
        b.append(", ");
        b.append("IsDelta=");
        b.append(this.isDelta);
        b.append(", ");
        b.append("TriggerTimeoutUserTime=");
        b.append(this.triggerTimeoutUserTime);
        b.append(", ");
        b.append("TriggerTimeoutDayOffset=");
        b.append(this.triggerTimeoutDayOffset);
        b.append(", ");
        b.append("UseRelativeAnalytics=");
        b.append(this.useRelativeAnalytics);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
