package thomsonreuters.dss.api.extractions.extractionrequests.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRequestBase;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierListBase;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ContentFieldNames", 
    "IdentifierList"})
public class TrancheFactorHistoryExtractionRequest extends ExtractionRequestBase implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ContentFieldNames")
    protected List<String> contentFieldNames;

    @JsonProperty("ContentFieldNames@nextLink")
    protected String contentFieldNamesNextLink;

    @JsonProperty("IdentifierList")
    protected InstrumentIdentifierListBase identifierList;

    protected TrancheFactorHistoryExtractionRequest() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TrancheFactorHistoryExtractionRequest";
    }

    @Property(name="ContentFieldNames")
    @JsonIgnore
    public CollectionPage<String> getContentFieldNames() {
        return new CollectionPage<String>(contextPath, String.class, contentFieldNames, Optional.ofNullable(contentFieldNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IdentifierList")
    @JsonIgnore
    public Optional<InstrumentIdentifierListBase> getIdentifierList() {
        return Optional.ofNullable(identifierList);
    }

    public TrancheFactorHistoryExtractionRequest withIdentifierList(InstrumentIdentifierListBase identifierList) {
        TrancheFactorHistoryExtractionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TrancheFactorHistoryExtractionRequest");
        _x.identifierList = identifierList;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTrancheFactorHistoryExtractionRequest() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> contentFieldNames;
        private String contentFieldNamesNextLink;
        private InstrumentIdentifierListBase identifierList;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder contentFieldNames(List<String> contentFieldNames) {
            this.contentFieldNames = contentFieldNames;
            this.changedFields = changedFields.add("ContentFieldNames");
            return this;
        }

        public Builder contentFieldNamesNextLink(String contentFieldNamesNextLink) {
            this.contentFieldNamesNextLink = contentFieldNamesNextLink;
            this.changedFields = changedFields.add("ContentFieldNames");
            return this;
        }

        public Builder identifierList(InstrumentIdentifierListBase identifierList) {
            this.identifierList = identifierList;
            this.changedFields = changedFields.add("IdentifierList");
            return this;
        }

        public TrancheFactorHistoryExtractionRequest build() {
            TrancheFactorHistoryExtractionRequest _x = new TrancheFactorHistoryExtractionRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TrancheFactorHistoryExtractionRequest";
            _x.contentFieldNames = contentFieldNames;
            _x.contentFieldNamesNextLink = contentFieldNamesNextLink;
            _x.identifierList = identifierList;
            return _x;
        }
    }

    private TrancheFactorHistoryExtractionRequest _copy() {
        TrancheFactorHistoryExtractionRequest _x = new TrancheFactorHistoryExtractionRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.contentFieldNames = contentFieldNames;
        _x.identifierList = identifierList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TrancheFactorHistoryExtractionRequest[");
        b.append("ContentFieldNames=");
        b.append(this.contentFieldNames);
        b.append(", ");
        b.append("IdentifierList=");
        b.append(this.identifierList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
