package thomsonreuters.dss.api.extractions.extractionrequests.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.IdentifierValidationError;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "JobId", 
    "Notes", 
    "IdentifierValidationErrors"})
public class RawExtractionResult implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.RawExtractionResult";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("JobId")
    protected String jobId;

    @JsonProperty("Notes")
    protected List<String> notes;

    @JsonProperty("Notes@nextLink")
    protected String notesNextLink;

    @JsonProperty("IdentifierValidationErrors")
    protected List<IdentifierValidationError> identifierValidationErrors;

    @JsonProperty("IdentifierValidationErrors@nextLink")
    protected String identifierValidationErrorsNextLink;

    protected RawExtractionResult() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String jobId;
        private List<String> notes;
        private String notesNextLink;
        private List<IdentifierValidationError> identifierValidationErrors;
        private String identifierValidationErrorsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.changedFields = changedFields.add("JobId");
            return this;
        }

        public Builder notes(List<String> notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("Notes");
            return this;
        }

        public Builder notesNextLink(String notesNextLink) {
            this.notesNextLink = notesNextLink;
            this.changedFields = changedFields.add("Notes");
            return this;
        }

        public Builder identifierValidationErrors(List<IdentifierValidationError> identifierValidationErrors) {
            this.identifierValidationErrors = identifierValidationErrors;
            this.changedFields = changedFields.add("IdentifierValidationErrors");
            return this;
        }

        public Builder identifierValidationErrorsNextLink(String identifierValidationErrorsNextLink) {
            this.identifierValidationErrorsNextLink = identifierValidationErrorsNextLink;
            this.changedFields = changedFields.add("IdentifierValidationErrors");
            return this;
        }

        public RawExtractionResult build() {
            RawExtractionResult _x = new RawExtractionResult();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.RawExtractionResult";
            _x.jobId = jobId;
            _x.notes = notes;
            _x.notesNextLink = notesNextLink;
            _x.identifierValidationErrors = identifierValidationErrors;
            _x.identifierValidationErrorsNextLink = identifierValidationErrorsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && jobId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(jobId.toString()));
        }
    }

    @Property(name="JobId")
    @JsonIgnore
    public Optional<String> getJobId() {
        return Optional.ofNullable(jobId);
    }

    public RawExtractionResult withJobId(String jobId) {
        RawExtractionResult _x = _copy();
        _x.changedFields = changedFields.add("JobId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.RawExtractionResult");
        _x.jobId = jobId;
        return _x;
    }

    @Property(name="Notes")
    @JsonIgnore
    public CollectionPage<String> getNotes() {
        return new CollectionPage<String>(contextPath, String.class, notes, Optional.ofNullable(notesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IdentifierValidationErrors")
    @JsonIgnore
    public CollectionPage<IdentifierValidationError> getIdentifierValidationErrors() {
        return new CollectionPage<IdentifierValidationError>(contextPath, IdentifierValidationError.class, identifierValidationErrors, Optional.ofNullable(identifierValidationErrorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RawExtractionResult patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RawExtractionResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RawExtractionResult put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RawExtractionResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RawExtractionResult _copy() {
        RawExtractionResult _x = new RawExtractionResult();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.jobId = jobId;
        _x.notes = notes;
        _x.identifierValidationErrors = identifierValidationErrors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RawExtractionResult[");
        b.append("JobId=");
        b.append(this.jobId);
        b.append(", ");
        b.append("Notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("IdentifierValidationErrors=");
        b.append(this.identifierValidationErrors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
