package thomsonreuters.dss.api.extractions.extractionrequests.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TriggerTimeoutDay implements Enum {

    @JsonProperty("CurrentDay")
    CURRENT_DAY("CurrentDay", "0"),

    @JsonProperty("FollowingDay")
    FOLLOWING_DAY("FollowingDay", "1");

    private final String name;
    private final String value;

    private TriggerTimeoutDay(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
