package thomsonreuters.dss.api.extractions.extractionrequests.schema;

import com.github.davidmoten.odata.client.ODataType;

import java.util.HashMap;
import java.util.Map;

import thomsonreuters.dss.api.complex.HourMinute;
import thomsonreuters.dss.api.content.complex.EntityIdentifier;
import thomsonreuters.dss.api.content.complex.HistoricalInstrumentIdentifier;
import thomsonreuters.dss.api.content.complex.InstrumentIdentifier;
import thomsonreuters.dss.api.content.complex.SubjectIdentifier;
import thomsonreuters.dss.api.content.complex.ValidatedEntity;
import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.extractions.complex.ExtractionLimit;
import thomsonreuters.dss.api.extractions.entity.TypeBase;
import thomsonreuters.dss.api.extractions.extractionconditions.entity.ExtractionConditionSelectionItem;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.BondScheduleExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.CommoditiesCorrectionsHistoryExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.CompositeExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.CorporateActionsIpoExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.CorporateActionsIsoExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.CorporateActionsStandardExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ElektronTimeseriesExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EndOfDayPricingCondition;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EndOfDayPricingExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EntityIdentifierList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EntityIdentifierListBase;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EntityListIdentifierList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EstimatesActualExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EstimatesDetailExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EstimatesFootnotesCompanyExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EstimatesFootnotesDetailExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.EstimatesSummaryExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRequestBase;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionResult;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.ExtractionRow;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.FixedIncomeAnalyticsExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.FundAllocationExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.HistoricalReferenceExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentCriteriaList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentCriteriaListIdentifierList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentIdentifierListBase;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.InstrumentListIdentifierList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.IntradayPricingExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.LegalEntityAuditExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.LegalEntityDetailExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.LegalEntityHierarchyExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.MBSFactorHistoryExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.NewsAnalyticsCommoditiesExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.NewsAnalyticsExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.NewsItemsExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.OwnershipExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.PremiumEndOfDayPricingExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.PremiumPricingExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.PriceHistoryExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.RatingsExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.SingleHistoricalPriceExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.SinglePriceHistoryExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.StarmineExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.SubjectIdentifierList;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.SymbolCrossReferenceExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TechnicalIndicatorsCondition;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TechnicalIndicatorsExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TermsAndConditionsExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TickHistoryIntradaySummariesExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TickHistoryMarketDepthExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TickHistoryRawExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TickHistoryTimeAndSalesExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TimeSeriesExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.complex.TrancheFactorHistoryExtractionRequest;
import thomsonreuters.dss.api.extractions.extractionrequests.entity.RawExtractionResult;
import thomsonreuters.dss.api.extractions.reportextractions.entity.ExtractedFile;
import thomsonreuters.dss.api.extractions.reportextractions.entity.OtherFile;
import thomsonreuters.dss.api.extractions.reportextractions.entity.ReportExtraction;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.BondScheduleCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CommoditiesCorrectionsHistoryCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CompositeCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentField;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentFieldDateFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentFieldFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentFieldNumberFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentFieldTextFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CorporateActionsIpoCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CorporateActionsIsoCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.CorporateActionsStandardCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ElektronTimeseriesCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EndOfDayPricingReportCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EstimatesActualCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EstimatesDetailCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EstimatesFootnotesCompanyCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EstimatesFootnotesDetailCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EstimatesSummaryCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.FundAllocationCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.HistoricalReferenceCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.IntradayPricingCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.LegalEntityDetailCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.LegalEntityHierarchyCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.NewsAnalyticsCommoditiesCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.NewsAnalyticsCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.NewsItemsCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.PremiumEndOfDayPricingCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.PremiumPricingCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.PremiumPricingUS3PMEstUdtCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.PremiumPricingUS4PMEstUdtCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.PriceHistoryCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.RatingLevel;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.RatingsCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportHeaderField;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportTemplateImportSettings;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportTemplatesImportResult;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.SingleHistoricalPriceCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.SinglePriceHistoryCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.SymbolCrossReferenceCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.TermsAndConditionsCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.TickHistoryIntradaySummariesCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.TickHistoryMarketDepthCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.TickHistoryRawCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.TickHistoryTimeAndSalesCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.TimeSeriesCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.BdfAssetType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.BdfRegion;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.BondScheduleReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.BondScheduleType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.CommoditiesCorrectionsHistoryReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.CompositeReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ContentFieldType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ContentSetType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.CorporateActionsIpoReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.CorporateActionsIsoReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.CorporateActionsStandardReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ElektronTimeseriesReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.EndOfDayPricingReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.EstimatesActualReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.EstimatesDetailReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.EstimatesFootnotesCompanyReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.EstimatesFootnotesDetailReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.EstimatesSummaryReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ExchangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.FixedIncomeAnalyticsReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.FundAllocationReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.HistoricalReferenceReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.IntradayPricingReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.LegalEntityAuditReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.LegalEntityDetailReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.LegalEntityHierarchyReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.MBSFactorHistoryReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsAnalyticsCommoditiesReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsAnalyticsReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsAttributionType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsCommodityType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsItemsReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsLanguageType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.NewsTopicType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.OwnershipReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.PremiumEndOfDayPricingReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.PremiumPricingReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.PriceHistoryReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.RatingSourceType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.RatingsReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ReportTemplateType;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.SingleHistoricalPriceReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.SinglePriceHistoryReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.StarmineReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.SymbolCrossReferenceReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TechnicalIndicatorsReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TermsAndConditionsReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TickHistoryIntradaySummariesReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TickHistoryMarketDepthReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TickHistoryRawReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TickHistoryTimeAndSalesReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TimeSeriesReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.TrancheFactorHistoryReportTemplate;
import thomsonreuters.dss.api.extractions.schedules.complex.CompositeExtendedTriggerInformation;
import thomsonreuters.dss.api.extractions.schedules.complex.DataAvailabilityTrigger;
import thomsonreuters.dss.api.extractions.schedules.complex.DataAvailabilityTriggerTimeout;
import thomsonreuters.dss.api.extractions.schedules.complex.EndOfDayExtendedTriggerInformation;
import thomsonreuters.dss.api.extractions.schedules.complex.ExtendedTriggerInformation;
import thomsonreuters.dss.api.extractions.schedules.complex.ImmediateTrigger;
import thomsonreuters.dss.api.extractions.schedules.complex.InstrumentTriggerDetail;
import thomsonreuters.dss.api.extractions.schedules.complex.MonthlyRecurrence;
import thomsonreuters.dss.api.extractions.schedules.complex.PremiumPricingExtendedTriggerInformation;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleImportResult;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleImportSettings;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleRecurrence;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleTrigger;
import thomsonreuters.dss.api.extractions.schedules.complex.SingleRecurrence;
import thomsonreuters.dss.api.extractions.schedules.complex.TechnicalIndicatorsExtendedTriggerInformation;
import thomsonreuters.dss.api.extractions.schedules.complex.TimeTrigger;
import thomsonreuters.dss.api.extractions.schedules.complex.WeeklyRecurrence;
import thomsonreuters.dss.api.extractions.schedules.entity.Schedule;
import thomsonreuters.dss.api.extractions.subjectlists.complex.AddToInstrumentListResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.BooleanFilter;
import thomsonreuters.dss.api.extractions.subjectlists.complex.CriteriaListFilter;
import thomsonreuters.dss.api.extractions.subjectlists.complex.DateRangeFilter;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesAppendIdentifiersResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesAppendResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesValidateIdentifiersResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesValidationResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityAppendDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityListImportResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityListImportSettings;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityValidationDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityValidationMessage;
import thomsonreuters.dss.api.extractions.subjectlists.complex.FilterInfo;
import thomsonreuters.dss.api.extractions.subjectlists.complex.FilterValue;
import thomsonreuters.dss.api.extractions.subjectlists.complex.IdentifierValidationError;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentAppendDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentListImportResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentListImportSettings;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentListValidationOptions;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentSegment;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentValidationDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentValidationMessage;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentValidationOptions;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentsAppendIdentifiersResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentsAppendResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentsValidateIdentifiersResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentsValidationResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.MultiValueFilter;
import thomsonreuters.dss.api.extractions.subjectlists.complex.RangeFilter;
import thomsonreuters.dss.api.extractions.subjectlists.complex.SingleValueFilter;
import thomsonreuters.dss.api.extractions.subjectlists.entity.CriteriaList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.EntityList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.EntityListItem;
import thomsonreuters.dss.api.extractions.subjectlists.entity.InstrumentList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.InstrumentListItem;
import thomsonreuters.dss.api.extractions.subjectlists.entity.SubjectList;
import thomsonreuters.dss.api.search.complex.CommoditySearchResult;
import thomsonreuters.dss.api.search.complex.EntitySearchResult;
import thomsonreuters.dss.api.search.complex.EquitySearchResult;
import thomsonreuters.dss.api.search.complex.FundSearchResult;
import thomsonreuters.dss.api.search.complex.HistoricalChainConstituent;
import thomsonreuters.dss.api.search.complex.HistoricalChainInstrument;
import thomsonreuters.dss.api.search.complex.HistoricalInstrumentRicChangeHistory;
import thomsonreuters.dss.api.search.complex.HistoricalLookupEntry;
import thomsonreuters.dss.api.search.complex.HistoricalSearchResult;
import thomsonreuters.dss.api.search.complex.MifidSubclassSearchResult;
import thomsonreuters.dss.api.search.complex.OtcsSearchResult;

public enum SchemaInfo implements com.github.davidmoten.odata.client.SchemaInfo {

    INSTANCE;

    private final Map<String, Class<? extends ODataType>> classes = new HashMap<>();

    private SchemaInfo() {
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.RawExtractionResult", RawExtractionResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.SubjectList", SubjectList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.CriteriaList", CriteriaList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityList", EntityList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListItem", EntityListItem.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentList", InstrumentList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem", InstrumentListItem.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile", OtherFile.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile", ExtractedFile.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction", ReportExtraction.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.TypeBase", TypeBase.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ExchangeType", ExchangeType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BdfRegion", BdfRegion.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAttributionType", NewsAttributionType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsCommodityType", NewsCommodityType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsLanguageType", NewsLanguageType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsTopicType", NewsTopicType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingSourceType", RatingSourceType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BdfAssetType", BdfAssetType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BondScheduleType", BondScheduleType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentSetType", ContentSetType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldType", ContentFieldType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateType", ReportTemplateType.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate", ReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CommoditiesCorrectionsHistoryReportTemplate", CommoditiesCorrectionsHistoryReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryReportTemplate", SinglePriceHistoryReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryReportTemplate", PriceHistoryReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesReportTemplate", ElektronTimeseriesReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceReportTemplate", HistoricalReferenceReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryIntradaySummariesReportTemplate", TickHistoryIntradaySummariesReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawReportTemplate", TickHistoryRawReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesReportTemplate", TickHistoryTimeAndSalesReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryMarketDepthReportTemplate", TickHistoryMarketDepthReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BondScheduleReportTemplate", BondScheduleReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoReportTemplate", CorporateActionsIpoReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoReportTemplate", CorporateActionsIsoReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardReportTemplate", CorporateActionsStandardReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesActualReportTemplate", EstimatesActualReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailReportTemplate", EstimatesDetailReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesFootnotesCompanyReportTemplate", EstimatesFootnotesCompanyReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesFootnotesDetailReportTemplate", EstimatesFootnotesDetailReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesSummaryReportTemplate", EstimatesSummaryReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.FundAllocationReportTemplate", FundAllocationReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.LegalEntityDetailReportTemplate", LegalEntityDetailReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.LegalEntityHierarchyReportTemplate", LegalEntityHierarchyReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesReportTemplate", NewsAnalyticsCommoditiesReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsReportTemplate", NewsItemsReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingReportTemplate", PremiumEndOfDayPricingReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingReportTemplate", PremiumPricingReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsReportTemplate", RatingsReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SingleHistoricalPriceReportTemplate", SingleHistoricalPriceReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.StarmineReportTemplate", StarmineReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceReportTemplate", SymbolCrossReferenceReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CompositeReportTemplate", CompositeReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.OwnershipReportTemplate", OwnershipReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TrancheFactorHistoryReportTemplate", TrancheFactorHistoryReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.MBSFactorHistoryReportTemplate", MBSFactorHistoryReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.LegalEntityAuditReportTemplate", LegalEntityAuditReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TechnicalIndicatorsReportTemplate", TechnicalIndicatorsReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.FixedIncomeAnalyticsReportTemplate", FixedIncomeAnalyticsReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.IntradayPricingReportTemplate", IntradayPricingReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EndOfDayPricingReportTemplate", EndOfDayPricingReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsReportTemplate", NewsAnalyticsReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsReportTemplate", TermsAndConditionsReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesReportTemplate", TimeSeriesReportTemplate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionConditions.ExtractionConditionSelectionItem", ExtractionConditionSelectionItem.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule", Schedule.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionRequestBase", ExtractionRequestBase.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionRow", ExtractionRow.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ExtractionResult", ExtractionResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingCondition", EndOfDayPricingCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CommoditiesCorrectionsHistoryExtractionRequest", CommoditiesCorrectionsHistoryExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.SubjectIdentifierList", SubjectIdentifierList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EntityIdentifierListBase", EntityIdentifierListBase.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EntityIdentifierList", EntityIdentifierList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EntityListIdentifierList", EntityListIdentifierList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentIdentifierListBase", InstrumentIdentifierListBase.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentCriteriaListIdentifierList", InstrumentCriteriaListIdentifierList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentCriteriaList", InstrumentCriteriaList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentIdentifierList", InstrumentIdentifierList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.InstrumentListIdentifierList", InstrumentListIdentifierList.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.SinglePriceHistoryExtractionRequest", SinglePriceHistoryExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.PriceHistoryExtractionRequest", PriceHistoryExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.HistoricalReferenceExtractionRequest", HistoricalReferenceExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TickHistoryIntradaySummariesExtractionRequest", TickHistoryIntradaySummariesExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TickHistoryMarketDepthExtractionRequest", TickHistoryMarketDepthExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.ElektronTimeseriesExtractionRequest", ElektronTimeseriesExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TickHistoryRawExtractionRequest", TickHistoryRawExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TickHistoryTimeAndSalesExtractionRequest", TickHistoryTimeAndSalesExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.BondScheduleExtractionRequest", BondScheduleExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CompositeExtractionRequest", CompositeExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIpoExtractionRequest", CorporateActionsIpoExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsIsoExtractionRequest", CorporateActionsIsoExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.CorporateActionsStandardExtractionRequest", CorporateActionsStandardExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EndOfDayPricingExtractionRequest", EndOfDayPricingExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EstimatesActualExtractionRequest", EstimatesActualExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EstimatesDetailExtractionRequest", EstimatesDetailExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EstimatesFootnotesCompanyExtractionRequest", EstimatesFootnotesCompanyExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EstimatesFootnotesDetailExtractionRequest", EstimatesFootnotesDetailExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.EstimatesSummaryExtractionRequest", EstimatesSummaryExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.FixedIncomeAnalyticsExtractionRequest", FixedIncomeAnalyticsExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.FundAllocationExtractionRequest", FundAllocationExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.IntradayPricingExtractionRequest", IntradayPricingExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.LegalEntityAuditExtractionRequest", LegalEntityAuditExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.LegalEntityHierarchyExtractionRequest", LegalEntityHierarchyExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.LegalEntityDetailExtractionRequest", LegalEntityDetailExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.MBSFactorHistoryExtractionRequest", MBSFactorHistoryExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.NewsAnalyticsCommoditiesExtractionRequest", NewsAnalyticsCommoditiesExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.NewsAnalyticsExtractionRequest", NewsAnalyticsExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.NewsItemsExtractionRequest", NewsItemsExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.OwnershipExtractionRequest", OwnershipExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.PremiumEndOfDayPricingExtractionRequest", PremiumEndOfDayPricingExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.PremiumPricingExtractionRequest", PremiumPricingExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.RatingsExtractionRequest", RatingsExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.SingleHistoricalPriceExtractionRequest", SingleHistoricalPriceExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.StarmineExtractionRequest", StarmineExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.SymbolCrossReferenceExtractionRequest", SymbolCrossReferenceExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsExtractionRequest", TechnicalIndicatorsExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TechnicalIndicatorsCondition", TechnicalIndicatorsCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TermsAndConditionsExtractionRequest", TermsAndConditionsExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TimeSeriesExtractionRequest", TimeSeriesExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionRequests.TrancheFactorHistoryExtractionRequest", TrancheFactorHistoryExtractionRequest.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.IdentifierValidationError", IdentifierValidationError.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.CriteriaListFilter", CriteriaListFilter.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.AddToInstrumentListResult", AddToInstrumentListResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterInfo", FilterInfo.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendIdentifiersResult", EntitiesAppendIdentifiersResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendResult", EntitiesAppendResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings", EntityListImportSettings.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult", EntityListImportResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidateIdentifiersResult", EntitiesValidateIdentifiersResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsAppendIdentifiersResult", InstrumentsAppendIdentifiersResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsAppendResult", InstrumentsAppendResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings", InstrumentListImportSettings.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportResult", InstrumentListImportResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidateIdentifiersResult", InstrumentsValidateIdentifiersResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions", InstrumentValidationOptions.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListValidationOptions", InstrumentListValidationOptions.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.MultiValueFilter", MultiValueFilter.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.SingleValueFilter", SingleValueFilter.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter", RangeFilter.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter", DateRangeFilter.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.BooleanFilter", BooleanFilter.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterValue", FilterValue.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidationResult", EntitiesValidationResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityValidationDuplicate", EntityValidationDuplicate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityValidationMessage", EntityValidationMessage.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityAppendDuplicate", EntityAppendDuplicate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidationResult", InstrumentsValidationResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentSegment", InstrumentSegment.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationDuplicate", InstrumentValidationDuplicate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationMessage", InstrumentValidationMessage.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentAppendDuplicate", InstrumentAppendDuplicate.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ExtractionLimit", ExtractionLimit.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField", ReportHeaderField.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField", ContentField.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateImportSettings", ReportTemplateImportSettings.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplatesImportResult", ReportTemplatesImportResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CommoditiesCorrectionsHistoryCondition", CommoditiesCorrectionsHistoryCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryCondition", SinglePriceHistoryCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryCondition", PriceHistoryCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition", ElektronTimeseriesCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition", HistoricalReferenceCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryIntradaySummariesCondition", TickHistoryIntradaySummariesCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition", TickHistoryRawCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition", TickHistoryTimeAndSalesCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryMarketDepthCondition", TickHistoryMarketDepthCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BondScheduleCondition", BondScheduleCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition", CorporateActionsIpoCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition", CorporateActionsIsoCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition", CorporateActionsStandardCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesActualCondition", EstimatesActualCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition", EstimatesDetailCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesFootnotesCompanyCondition", EstimatesFootnotesCompanyCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesFootnotesDetailCondition", EstimatesFootnotesDetailCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesSummaryCondition", EstimatesSummaryCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.FundAllocationCondition", FundAllocationCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.LegalEntityDetailCondition", LegalEntityDetailCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.LegalEntityHierarchyCondition", LegalEntityHierarchyCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition", NewsAnalyticsCommoditiesCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition", NewsItemsCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingCondition", PremiumEndOfDayPricingCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingCondition", PremiumPricingCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition", RatingsCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SingleHistoricalPriceCondition", SingleHistoricalPriceCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition", SymbolCrossReferenceCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CompositeCondition", CompositeCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.IntradayPricingCondition", IntradayPricingCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EndOfDayPricingReportCondition", EndOfDayPricingReportCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCondition", NewsAnalyticsCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition", TermsAndConditionsCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition", TimeSeriesCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingUS3PMEstUdtCondition", PremiumPricingUS3PMEstUdtCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingUS4PMEstUdtCondition", PremiumPricingUS4PMEstUdtCondition.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldFormat", ContentFieldFormat.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldNumberFormat", ContentFieldNumberFormat.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldDateFormat", ContentFieldDateFormat.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldTextFormat", ContentFieldTextFormat.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingLevel", RatingLevel.class);
        classes.put("ThomsonReuters.Dss.Api.Content.SubjectIdentifier", SubjectIdentifier.class);
        classes.put("ThomsonReuters.Dss.Api.Content.EntityIdentifier", EntityIdentifier.class);
        classes.put("ThomsonReuters.Dss.Api.Content.ValidatedEntity", ValidatedEntity.class);
        classes.put("ThomsonReuters.Dss.Api.Content.InstrumentIdentifier", InstrumentIdentifier.class);
        classes.put("ThomsonReuters.Dss.Api.Content.ValidatedInstrument", ValidatedInstrument.class);
        classes.put("ThomsonReuters.Dss.Api.Content.HistoricalInstrumentIdentifier", HistoricalInstrumentIdentifier.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleRecurrence", ScheduleRecurrence.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleTrigger", ScheduleTrigger.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleImportSettings", ScheduleImportSettings.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleImportResult", ScheduleImportResult.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail", InstrumentTriggerDetail.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.SingleRecurrence", SingleRecurrence.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.WeeklyRecurrence", WeeklyRecurrence.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.MonthlyRecurrence", MonthlyRecurrence.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.TimeTrigger", TimeTrigger.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTrigger", DataAvailabilityTrigger.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.ExtendedTriggerInformation", ExtendedTriggerInformation.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.EndOfDayExtendedTriggerInformation", EndOfDayExtendedTriggerInformation.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.CompositeExtendedTriggerInformation", CompositeExtendedTriggerInformation.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.TechnicalIndicatorsExtendedTriggerInformation", TechnicalIndicatorsExtendedTriggerInformation.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.PremiumPricingExtendedTriggerInformation", PremiumPricingExtendedTriggerInformation.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTriggerTimeout", DataAvailabilityTriggerTimeout.class);
        classes.put("ThomsonReuters.Dss.Api.Extractions.Schedules.ImmediateTrigger", ImmediateTrigger.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalLookupEntry", HistoricalLookupEntry.class);
        classes.put("ThomsonReuters.Dss.Api.Search.FundSearchResult", FundSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.EntitySearchResult", EntitySearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.OtcsSearchResult", OtcsSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.MifidSubclassSearchResult", MifidSubclassSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.CommoditySearchResult", CommoditySearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalSearchResult", HistoricalSearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory", HistoricalInstrumentRicChangeHistory.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalChainInstrument", HistoricalChainInstrument.class);
        classes.put("ThomsonReuters.Dss.Api.Search.HistoricalChainConstituent", HistoricalChainConstituent.class);
        classes.put("ThomsonReuters.Dss.Api.Search.EquitySearchResult", EquitySearchResult.class);
        classes.put("ThomsonReuters.Dss.Api.HourMinute", HourMinute.class);
    }

    @Override
    public Class<? extends ODataType> getClassFromTypeWithNamespace(String name) {
        return classes.get(name);
    }

}
