package thomsonreuters.dss.api.extractions.reportextractions.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.reportextractions.collection.request.ExtractedFileCollectionRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.ReportExtraction;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ExtractedFileEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo;

public class ReportExtractionCollectionRequest extends CollectionPageEntityRequest<ReportExtraction, ReportExtractionEntityRequest>{

    protected ContextPath contextPath;

    public ReportExtractionCollectionRequest(ContextPath contextPath) {
        super(contextPath, ReportExtraction.class, cp -> new ReportExtractionEntityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ExtractedFileCollectionRequest files() {
        return new ExtractedFileCollectionRequest(contextPath.addSegment("Files"));
    }

    public ExtractedFileEntityRequest files(String extractedFileId) {
        return new ExtractedFileEntityRequest(contextPath.addSegment("Files").addKeys(new NameValue(extractedFileId.toString())));
    }




}
