package thomsonreuters.dss.api.extractions.reportextractions.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.enums.ExtractedFileType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ExtractedFileId", 
    "ReportExtractionId", 
    "ScheduleId", 
    "FileType", 
    "ExtractedFileName", 
    "LastWriteTimeUtc", 
    "ContentsExists", 
    "Size", 
    "ReceivedDateUtc"})
public class ExtractedFile implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ExtractedFileId")
    protected String extractedFileId;

    @JsonProperty("ReportExtractionId")
    protected String reportExtractionId;

    @JsonProperty("ScheduleId")
    protected String scheduleId;

    @JsonProperty("FileType")
    protected ExtractedFileType fileType;

    @JsonProperty("ExtractedFileName")
    protected String extractedFileName;

    @JsonProperty("LastWriteTimeUtc")
    protected OffsetDateTime lastWriteTimeUtc;

    @JsonProperty("ContentsExists")
    protected Boolean contentsExists;

    @JsonProperty("Size")
    protected Long size;

    @JsonProperty("ReceivedDateUtc")
    protected OffsetDateTime receivedDateUtc;

    protected ExtractedFile() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String extractedFileId;
        private String reportExtractionId;
        private String scheduleId;
        private ExtractedFileType fileType;
        private String extractedFileName;
        private OffsetDateTime lastWriteTimeUtc;
        private Boolean contentsExists;
        private Long size;
        private OffsetDateTime receivedDateUtc;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder extractedFileId(String extractedFileId) {
            this.extractedFileId = extractedFileId;
            this.changedFields = changedFields.add("ExtractedFileId");
            return this;
        }

        public Builder reportExtractionId(String reportExtractionId) {
            this.reportExtractionId = reportExtractionId;
            this.changedFields = changedFields.add("ReportExtractionId");
            return this;
        }

        public Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            this.changedFields = changedFields.add("ScheduleId");
            return this;
        }

        public Builder fileType(ExtractedFileType fileType) {
            this.fileType = fileType;
            this.changedFields = changedFields.add("FileType");
            return this;
        }

        public Builder extractedFileName(String extractedFileName) {
            this.extractedFileName = extractedFileName;
            this.changedFields = changedFields.add("ExtractedFileName");
            return this;
        }

        public Builder lastWriteTimeUtc(OffsetDateTime lastWriteTimeUtc) {
            this.lastWriteTimeUtc = lastWriteTimeUtc;
            this.changedFields = changedFields.add("LastWriteTimeUtc");
            return this;
        }

        public Builder contentsExists(Boolean contentsExists) {
            this.contentsExists = contentsExists;
            this.changedFields = changedFields.add("ContentsExists");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("Size");
            return this;
        }

        public Builder receivedDateUtc(OffsetDateTime receivedDateUtc) {
            this.receivedDateUtc = receivedDateUtc;
            this.changedFields = changedFields.add("ReceivedDateUtc");
            return this;
        }

        public ExtractedFile build() {
            ExtractedFile _x = new ExtractedFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile";
            _x.extractedFileId = extractedFileId;
            _x.reportExtractionId = reportExtractionId;
            _x.scheduleId = scheduleId;
            _x.fileType = fileType;
            _x.extractedFileName = extractedFileName;
            _x.lastWriteTimeUtc = lastWriteTimeUtc;
            _x.contentsExists = contentsExists;
            _x.size = size;
            _x.receivedDateUtc = receivedDateUtc;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && extractedFileId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(extractedFileId.toString()));
        }
    }

    @Property(name="ExtractedFileId")
    @JsonIgnore
    public Optional<String> getExtractedFileId() {
        return Optional.ofNullable(extractedFileId);
    }

    public ExtractedFile withExtractedFileId(String extractedFileId) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("ExtractedFileId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.extractedFileId = extractedFileId;
        return _x;
    }

    @Property(name="ReportExtractionId")
    @JsonIgnore
    public Optional<String> getReportExtractionId() {
        return Optional.ofNullable(reportExtractionId);
    }

    public ExtractedFile withReportExtractionId(String reportExtractionId) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("ReportExtractionId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.reportExtractionId = reportExtractionId;
        return _x;
    }

    @Property(name="ScheduleId")
    @JsonIgnore
    public Optional<String> getScheduleId() {
        return Optional.ofNullable(scheduleId);
    }

    public ExtractedFile withScheduleId(String scheduleId) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("ScheduleId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.scheduleId = scheduleId;
        return _x;
    }

    @Property(name="FileType")
    @JsonIgnore
    public Optional<ExtractedFileType> getFileType() {
        return Optional.ofNullable(fileType);
    }

    public ExtractedFile withFileType(ExtractedFileType fileType) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("FileType");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.fileType = fileType;
        return _x;
    }

    @Property(name="ExtractedFileName")
    @JsonIgnore
    public Optional<String> getExtractedFileName() {
        return Optional.ofNullable(extractedFileName);
    }

    public ExtractedFile withExtractedFileName(String extractedFileName) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("ExtractedFileName");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.extractedFileName = extractedFileName;
        return _x;
    }

    @Property(name="LastWriteTimeUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastWriteTimeUtc() {
        return Optional.ofNullable(lastWriteTimeUtc);
    }

    public ExtractedFile withLastWriteTimeUtc(OffsetDateTime lastWriteTimeUtc) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("LastWriteTimeUtc");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.lastWriteTimeUtc = lastWriteTimeUtc;
        return _x;
    }

    @Property(name="ContentsExists")
    @JsonIgnore
    public Optional<Boolean> getContentsExists() {
        return Optional.ofNullable(contentsExists);
    }

    public ExtractedFile withContentsExists(Boolean contentsExists) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("ContentsExists");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.contentsExists = contentsExists;
        return _x;
    }

    @Property(name="Size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public ExtractedFile withSize(Long size) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("Size");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.size = size;
        return _x;
    }

    @Property(name="ReceivedDateUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getReceivedDateUtc() {
        return Optional.ofNullable(receivedDateUtc);
    }

    public ExtractedFile withReceivedDateUtc(OffsetDateTime receivedDateUtc) {
        ExtractedFile _x = _copy();
        _x.changedFields = changedFields.add("ReceivedDateUtc");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ExtractedFile");
        _x.receivedDateUtc = receivedDateUtc;
        return _x;
    }

    @NavigationProperty(name="Extraction")
    @JsonIgnore
    public ReportExtractionEntityRequest getExtraction() {
        return new ReportExtractionEntityRequest(contextPath.addSegment("Extraction"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExtractedFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExtractedFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExtractedFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExtractedFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExtractedFile _copy() {
        ExtractedFile _x = new ExtractedFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.extractedFileId = extractedFileId;
        _x.reportExtractionId = reportExtractionId;
        _x.scheduleId = scheduleId;
        _x.fileType = fileType;
        _x.extractedFileName = extractedFileName;
        _x.lastWriteTimeUtc = lastWriteTimeUtc;
        _x.contentsExists = contentsExists;
        _x.size = size;
        _x.receivedDateUtc = receivedDateUtc;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractedFile[");
        b.append("ExtractedFileId=");
        b.append(this.extractedFileId);
        b.append(", ");
        b.append("ReportExtractionId=");
        b.append(this.reportExtractionId);
        b.append(", ");
        b.append("ScheduleId=");
        b.append(this.scheduleId);
        b.append(", ");
        b.append("FileType=");
        b.append(this.fileType);
        b.append(", ");
        b.append("ExtractedFileName=");
        b.append(this.extractedFileName);
        b.append(", ");
        b.append("LastWriteTimeUtc=");
        b.append(this.lastWriteTimeUtc);
        b.append(", ");
        b.append("ContentsExists=");
        b.append(this.contentsExists);
        b.append(", ");
        b.append("Size=");
        b.append(this.size);
        b.append(", ");
        b.append("ReceivedDateUtc=");
        b.append(this.receivedDateUtc);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
