package thomsonreuters.dss.api.extractions.reportextractions.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reportextractions.enums.ExtractedFileType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "OtherFileId", 
    "FileName", 
    "LastWriteTimeUtc", 
    "Size", 
    "FileType"})
public class OtherFile implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("OtherFileId")
    protected String otherFileId;

    @JsonProperty("FileName")
    protected String fileName;

    @JsonProperty("LastWriteTimeUtc")
    protected OffsetDateTime lastWriteTimeUtc;

    @JsonProperty("Size")
    protected Long size;

    @JsonProperty("FileType")
    protected ExtractedFileType fileType;

    protected OtherFile() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String otherFileId;
        private String fileName;
        private OffsetDateTime lastWriteTimeUtc;
        private Long size;
        private ExtractedFileType fileType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder otherFileId(String otherFileId) {
            this.otherFileId = otherFileId;
            this.changedFields = changedFields.add("OtherFileId");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("FileName");
            return this;
        }

        public Builder lastWriteTimeUtc(OffsetDateTime lastWriteTimeUtc) {
            this.lastWriteTimeUtc = lastWriteTimeUtc;
            this.changedFields = changedFields.add("LastWriteTimeUtc");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("Size");
            return this;
        }

        public Builder fileType(ExtractedFileType fileType) {
            this.fileType = fileType;
            this.changedFields = changedFields.add("FileType");
            return this;
        }

        public OtherFile build() {
            OtherFile _x = new OtherFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile";
            _x.otherFileId = otherFileId;
            _x.fileName = fileName;
            _x.lastWriteTimeUtc = lastWriteTimeUtc;
            _x.size = size;
            _x.fileType = fileType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && otherFileId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(otherFileId.toString()));
        }
    }

    @Property(name="OtherFileId")
    @JsonIgnore
    public Optional<String> getOtherFileId() {
        return Optional.ofNullable(otherFileId);
    }

    public OtherFile withOtherFileId(String otherFileId) {
        OtherFile _x = _copy();
        _x.changedFields = changedFields.add("OtherFileId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile");
        _x.otherFileId = otherFileId;
        return _x;
    }

    @Property(name="FileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public OtherFile withFileName(String fileName) {
        OtherFile _x = _copy();
        _x.changedFields = changedFields.add("FileName");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="LastWriteTimeUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastWriteTimeUtc() {
        return Optional.ofNullable(lastWriteTimeUtc);
    }

    public OtherFile withLastWriteTimeUtc(OffsetDateTime lastWriteTimeUtc) {
        OtherFile _x = _copy();
        _x.changedFields = changedFields.add("LastWriteTimeUtc");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile");
        _x.lastWriteTimeUtc = lastWriteTimeUtc;
        return _x;
    }

    @Property(name="Size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public OtherFile withSize(Long size) {
        OtherFile _x = _copy();
        _x.changedFields = changedFields.add("Size");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile");
        _x.size = size;
        return _x;
    }

    @Property(name="FileType")
    @JsonIgnore
    public Optional<ExtractedFileType> getFileType() {
        return Optional.ofNullable(fileType);
    }

    public OtherFile withFileType(ExtractedFileType fileType) {
        OtherFile _x = _copy();
        _x.changedFields = changedFields.add("FileType");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.OtherFile");
        _x.fileType = fileType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OtherFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OtherFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OtherFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OtherFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OtherFile _copy() {
        OtherFile _x = new OtherFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.otherFileId = otherFileId;
        _x.fileName = fileName;
        _x.lastWriteTimeUtc = lastWriteTimeUtc;
        _x.size = size;
        _x.fileType = fileType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OtherFile[");
        b.append("OtherFileId=");
        b.append(this.otherFileId);
        b.append(", ");
        b.append("FileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("LastWriteTimeUtc=");
        b.append(this.lastWriteTimeUtc);
        b.append(", ");
        b.append("Size=");
        b.append(this.size);
        b.append(", ");
        b.append("FileType=");
        b.append(this.fileType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
