package thomsonreuters.dss.api.extractions.reportextractions.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reportextractions.collection.request.ExtractedFileCollectionRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ExtractedFileEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.enums.ReportExtractionDetailedStatus;
import thomsonreuters.dss.api.extractions.reportextractions.enums.ReportExtractionStatus;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportExtractionId", 
    "ScheduleId", 
    "Status", 
    "DetailedStatus", 
    "ExtractionDateUtc", 
    "ScheduleName", 
    "IsTriggered", 
    "ExtractionStartUtc", 
    "ExtractionEndUtc"})
public class ReportExtraction implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportExtractionId")
    protected String reportExtractionId;

    @JsonProperty("ScheduleId")
    protected String scheduleId;

    @JsonProperty("Status")
    protected ReportExtractionStatus status;

    @JsonProperty("DetailedStatus")
    protected ReportExtractionDetailedStatus detailedStatus;

    @JsonProperty("ExtractionDateUtc")
    protected OffsetDateTime extractionDateUtc;

    @JsonProperty("ScheduleName")
    protected String scheduleName;

    @JsonProperty("IsTriggered")
    protected Boolean isTriggered;

    @JsonProperty("ExtractionStartUtc")
    protected OffsetDateTime extractionStartUtc;

    @JsonProperty("ExtractionEndUtc")
    protected OffsetDateTime extractionEndUtc;

    protected ReportExtraction() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String reportExtractionId;
        private String scheduleId;
        private ReportExtractionStatus status;
        private ReportExtractionDetailedStatus detailedStatus;
        private OffsetDateTime extractionDateUtc;
        private String scheduleName;
        private Boolean isTriggered;
        private OffsetDateTime extractionStartUtc;
        private OffsetDateTime extractionEndUtc;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportExtractionId(String reportExtractionId) {
            this.reportExtractionId = reportExtractionId;
            this.changedFields = changedFields.add("ReportExtractionId");
            return this;
        }

        public Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            this.changedFields = changedFields.add("ScheduleId");
            return this;
        }

        public Builder status(ReportExtractionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder detailedStatus(ReportExtractionDetailedStatus detailedStatus) {
            this.detailedStatus = detailedStatus;
            this.changedFields = changedFields.add("DetailedStatus");
            return this;
        }

        public Builder extractionDateUtc(OffsetDateTime extractionDateUtc) {
            this.extractionDateUtc = extractionDateUtc;
            this.changedFields = changedFields.add("ExtractionDateUtc");
            return this;
        }

        public Builder scheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
            this.changedFields = changedFields.add("ScheduleName");
            return this;
        }

        public Builder isTriggered(Boolean isTriggered) {
            this.isTriggered = isTriggered;
            this.changedFields = changedFields.add("IsTriggered");
            return this;
        }

        public Builder extractionStartUtc(OffsetDateTime extractionStartUtc) {
            this.extractionStartUtc = extractionStartUtc;
            this.changedFields = changedFields.add("ExtractionStartUtc");
            return this;
        }

        public Builder extractionEndUtc(OffsetDateTime extractionEndUtc) {
            this.extractionEndUtc = extractionEndUtc;
            this.changedFields = changedFields.add("ExtractionEndUtc");
            return this;
        }

        public ReportExtraction build() {
            ReportExtraction _x = new ReportExtraction();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction";
            _x.reportExtractionId = reportExtractionId;
            _x.scheduleId = scheduleId;
            _x.status = status;
            _x.detailedStatus = detailedStatus;
            _x.extractionDateUtc = extractionDateUtc;
            _x.scheduleName = scheduleName;
            _x.isTriggered = isTriggered;
            _x.extractionStartUtc = extractionStartUtc;
            _x.extractionEndUtc = extractionEndUtc;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && reportExtractionId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(reportExtractionId.toString()));
        }
    }

    @Property(name="ReportExtractionId")
    @JsonIgnore
    public Optional<String> getReportExtractionId() {
        return Optional.ofNullable(reportExtractionId);
    }

    public ReportExtraction withReportExtractionId(String reportExtractionId) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("ReportExtractionId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.reportExtractionId = reportExtractionId;
        return _x;
    }

    @Property(name="ScheduleId")
    @JsonIgnore
    public Optional<String> getScheduleId() {
        return Optional.ofNullable(scheduleId);
    }

    public ReportExtraction withScheduleId(String scheduleId) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("ScheduleId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.scheduleId = scheduleId;
        return _x;
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<ReportExtractionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ReportExtraction withStatus(ReportExtractionStatus status) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("Status");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.status = status;
        return _x;
    }

    @Property(name="DetailedStatus")
    @JsonIgnore
    public Optional<ReportExtractionDetailedStatus> getDetailedStatus() {
        return Optional.ofNullable(detailedStatus);
    }

    public ReportExtraction withDetailedStatus(ReportExtractionDetailedStatus detailedStatus) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("DetailedStatus");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.detailedStatus = detailedStatus;
        return _x;
    }

    @Property(name="ExtractionDateUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getExtractionDateUtc() {
        return Optional.ofNullable(extractionDateUtc);
    }

    public ReportExtraction withExtractionDateUtc(OffsetDateTime extractionDateUtc) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("ExtractionDateUtc");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.extractionDateUtc = extractionDateUtc;
        return _x;
    }

    @Property(name="ScheduleName")
    @JsonIgnore
    public Optional<String> getScheduleName() {
        return Optional.ofNullable(scheduleName);
    }

    public ReportExtraction withScheduleName(String scheduleName) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("ScheduleName");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.scheduleName = scheduleName;
        return _x;
    }

    @Property(name="IsTriggered")
    @JsonIgnore
    public Optional<Boolean> getIsTriggered() {
        return Optional.ofNullable(isTriggered);
    }

    public ReportExtraction withIsTriggered(Boolean isTriggered) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("IsTriggered");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.isTriggered = isTriggered;
        return _x;
    }

    @Property(name="ExtractionStartUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getExtractionStartUtc() {
        return Optional.ofNullable(extractionStartUtc);
    }

    public ReportExtraction withExtractionStartUtc(OffsetDateTime extractionStartUtc) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("ExtractionStartUtc");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.extractionStartUtc = extractionStartUtc;
        return _x;
    }

    @Property(name="ExtractionEndUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getExtractionEndUtc() {
        return Optional.ofNullable(extractionEndUtc);
    }

    public ReportExtraction withExtractionEndUtc(OffsetDateTime extractionEndUtc) {
        ReportExtraction _x = _copy();
        _x.changedFields = changedFields.add("ExtractionEndUtc");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportExtractions.ReportExtraction");
        _x.extractionEndUtc = extractionEndUtc;
        return _x;
    }

    @NavigationProperty(name="Files")
    @JsonIgnore
    public ExtractedFileCollectionRequest getFiles() {
        return new ExtractedFileCollectionRequest(
                        contextPath.addSegment("Files"));
    }

    @NavigationProperty(name="FullFile")
    @JsonIgnore
    public ExtractedFileEntityRequest getFullFile() {
        return new ExtractedFileEntityRequest(contextPath.addSegment("FullFile"));
    }

    @NavigationProperty(name="NotesFile")
    @JsonIgnore
    public ExtractedFileEntityRequest getNotesFile() {
        return new ExtractedFileEntityRequest(contextPath.addSegment("NotesFile"));
    }

    @NavigationProperty(name="RicMaintenanceFile")
    @JsonIgnore
    public ExtractedFileEntityRequest getRicMaintenanceFile() {
        return new ExtractedFileEntityRequest(contextPath.addSegment("RicMaintenanceFile"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportExtraction patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ReportExtraction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportExtraction put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ReportExtraction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ReportExtraction _copy() {
        ReportExtraction _x = new ReportExtraction();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportExtractionId = reportExtractionId;
        _x.scheduleId = scheduleId;
        _x.status = status;
        _x.detailedStatus = detailedStatus;
        _x.extractionDateUtc = extractionDateUtc;
        _x.scheduleName = scheduleName;
        _x.isTriggered = isTriggered;
        _x.extractionStartUtc = extractionStartUtc;
        _x.extractionEndUtc = extractionEndUtc;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReportExtraction[");
        b.append("ReportExtractionId=");
        b.append(this.reportExtractionId);
        b.append(", ");
        b.append("ScheduleId=");
        b.append(this.scheduleId);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("DetailedStatus=");
        b.append(this.detailedStatus);
        b.append(", ");
        b.append("ExtractionDateUtc=");
        b.append(this.extractionDateUtc);
        b.append(", ");
        b.append("ScheduleName=");
        b.append(this.scheduleName);
        b.append(", ");
        b.append("IsTriggered=");
        b.append(this.isTriggered);
        b.append(", ");
        b.append("ExtractionStartUtc=");
        b.append(this.extractionStartUtc);
        b.append(", ");
        b.append("ExtractionEndUtc=");
        b.append(this.extractionEndUtc);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
