package thomsonreuters.dss.api.extractions.reportextractions.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import thomsonreuters.dss.api.extractions.reportextractions.entity.ExtractedFile;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo;

@JsonIgnoreType
public class ExtractedFileEntityRequest extends EntityRequest<ExtractedFile> {

    public ExtractedFileEntityRequest(ContextPath contextPath) {
        super(ExtractedFile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ReportExtractionEntityRequest extraction() {
        return new ReportExtractionEntityRequest(contextPath.addSegment("Extraction"));
    }

}
