package thomsonreuters.dss.api.extractions.reportextractions.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.reportextractions.collection.request.ExtractedFileCollectionRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.ReportExtraction;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ExtractedFileEntityRequest;
import thomsonreuters.dss.api.extractions.reportextractions.schema.SchemaInfo;

@JsonIgnoreType
public class ReportExtractionEntityRequest extends EntityRequest<ReportExtraction> {

    public ReportExtractionEntityRequest(ContextPath contextPath) {
        super(ReportExtraction.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ExtractedFileCollectionRequest files() {
        return new ExtractedFileCollectionRequest(
                        contextPath.addSegment("Files"));
    }

    public ExtractedFileEntityRequest files(String extractedFileId) {
        return new ExtractedFileEntityRequest(contextPath.addSegment("Files").addKeys(new NameValue(extractedFileId.toString())));
    }

    public ExtractedFileEntityRequest fullFile() {
        return new ExtractedFileEntityRequest(contextPath.addSegment("FullFile"));
    }

    public ExtractedFileEntityRequest notesFile() {
        return new ExtractedFileEntityRequest(contextPath.addSegment("NotesFile"));
    }

    public ExtractedFileEntityRequest ricMaintenanceFile() {
        return new ExtractedFileEntityRequest(contextPath.addSegment("RicMaintenanceFile"));
    }

}
