package thomsonreuters.dss.api.extractions.reportextractions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ExtractedFileType implements Enum {

    @JsonProperty("Note")
    NOTE("Note", "0"),

    @JsonProperty("RicMaintenanceNote")
    RIC_MAINTENANCE_NOTE("RicMaintenanceNote", "1"),

    @JsonProperty("Full")
    FULL("Full", "2"),

    @JsonProperty("Partial")
    PARTIAL("Partial", "3"),

    @JsonProperty("Other")
    OTHER("Other", "4");

    private final String name;
    private final String value;

    private ExtractedFileType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
