package thomsonreuters.dss.api.extractions.reportextractions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportExtractionDetailedStatus implements Enum {

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "0"),

    @JsonProperty("Wait")
    WAIT("Wait", "1"),

    @JsonProperty("Preprocessing")
    PREPROCESSING("Preprocessing", "2"),

    @JsonProperty("WaitingForPreExtractCompletion")
    WAITING_FOR_PRE_EXTRACT_COMPLETION("WaitingForPreExtractCompletion", "3"),

    @JsonProperty("Sending")
    SENDING("Sending", "4"),

    @JsonProperty("Sent")
    SENT("Sent", "5"),

    @JsonProperty("Queued")
    QUEUED("Queued", "6"),

    @JsonProperty("Processing")
    PROCESSING("Processing", "7"),

    @JsonProperty("QueuedForFormatting")
    QUEUED_FOR_FORMATTING("QueuedForFormatting", "8"),

    @JsonProperty("Formatting")
    FORMATTING("Formatting", "9"),

    @JsonProperty("Done")
    DONE("Done", "10"),

    @JsonProperty("Fail")
    FAIL("Fail", "11"),

    @JsonProperty("Cancelled")
    CANCELLED("Cancelled", "12"),

    @JsonProperty("Retry")
    RETRY("Retry", "13"),

    @JsonProperty("Embargoed")
    EMBARGOED("Embargoed", "14"),

    @JsonProperty("PendingDelivery")
    PENDING_DELIVERY("PendingDelivery", "15"),

    @JsonProperty("Delivering")
    DELIVERING("Delivering", "16");

    private final String name;
    private final String value;

    private ReportExtractionDetailedStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
