package thomsonreuters.dss.api.extractions.reportextractions.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportExtractionStatus implements Enum {

    @JsonProperty("Completed")
    COMPLETED("Completed", "0"),

    @JsonProperty("Pending")
    PENDING("Pending", "1"),

    @JsonProperty("Processing")
    PROCESSING("Processing", "2"),

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "3");

    private final String name;
    private final String value;

    private ReportExtractionStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
