package thomsonreuters.dss.api.extractions.reporttemplates.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.reporttemplates.entity.ReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.schedules.collection.request.ScheduleCollectionRequest;
import thomsonreuters.dss.api.extractions.schedules.entity.request.ScheduleEntityRequest;

public class ReportTemplateCollectionRequest extends CollectionPageEntityRequest<ReportTemplate, ReportTemplateEntityRequest>{

    protected ContextPath contextPath;

    public ReportTemplateCollectionRequest(ContextPath contextPath) {
        super(contextPath, ReportTemplate.class, cp -> new ReportTemplateEntityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public ScheduleCollectionRequest schedules() {
        return new ScheduleCollectionRequest(contextPath.addSegment("Schedules"));
    }

    public ScheduleEntityRequest schedules(String scheduleId) {
        return new ScheduleEntityRequest(contextPath.addSegment("Schedules").addKeys(new NameValue(scheduleId.toString())));
    }

}
