package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "BondScheduleTypeCodes"})
public class BondScheduleCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("BondScheduleTypeCodes")
    protected List<String> bondScheduleTypeCodes;

    @JsonProperty("BondScheduleTypeCodes@nextLink")
    protected String bondScheduleTypeCodesNextLink;

    protected BondScheduleCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BondScheduleCondition";
    }

    @Property(name="BondScheduleTypeCodes")
    @JsonIgnore
    public CollectionPage<String> getBondScheduleTypeCodes() {
        return new CollectionPage<String>(contextPath, String.class, bondScheduleTypeCodes, Optional.ofNullable(bondScheduleTypeCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> bondScheduleTypeCodes;
        private String bondScheduleTypeCodesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder bondScheduleTypeCodes(List<String> bondScheduleTypeCodes) {
            this.bondScheduleTypeCodes = bondScheduleTypeCodes;
            this.changedFields = changedFields.add("BondScheduleTypeCodes");
            return this;
        }

        public Builder bondScheduleTypeCodesNextLink(String bondScheduleTypeCodesNextLink) {
            this.bondScheduleTypeCodesNextLink = bondScheduleTypeCodesNextLink;
            this.changedFields = changedFields.add("BondScheduleTypeCodes");
            return this;
        }

        public BondScheduleCondition build() {
            BondScheduleCondition _x = new BondScheduleCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.BondScheduleCondition";
            _x.bondScheduleTypeCodes = bondScheduleTypeCodes;
            _x.bondScheduleTypeCodesNextLink = bondScheduleTypeCodesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BondScheduleCondition[");
        b.append("BondScheduleTypeCodes=");
        b.append(this.bondScheduleTypeCodes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
