package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentFieldFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ContentFieldJustification;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ContentFieldWidthStyle;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "FieldName", 
    "Justification", 
    "Label", 
    "Width", 
    "WidthStyle", 
    "Format"})
public class ContentField implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FieldName")
    protected String fieldName;

    @JsonProperty("Justification")
    protected ContentFieldJustification justification;

    @JsonProperty("Label")
    protected String label;

    @JsonProperty("Width")
    protected Integer width;

    @JsonProperty("WidthStyle")
    protected ContentFieldWidthStyle widthStyle;

    @JsonProperty("Format")
    protected ContentFieldFormat format;

    protected ContentField() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField";
    }

    @Property(name="FieldName")
    @JsonIgnore
    public Optional<String> getFieldName() {
        return Optional.ofNullable(fieldName);
    }

    public ContentField withFieldName(String fieldName) {
        ContentField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField");
        _x.fieldName = fieldName;
        return _x;
    }

    @Property(name="Justification")
    @JsonIgnore
    public Optional<ContentFieldJustification> getJustification() {
        return Optional.ofNullable(justification);
    }

    public ContentField withJustification(ContentFieldJustification justification) {
        ContentField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField");
        _x.justification = justification;
        return _x;
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public ContentField withLabel(String label) {
        ContentField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField");
        _x.label = label;
        return _x;
    }

    @Property(name="Width")
    @JsonIgnore
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    public ContentField withWidth(Integer width) {
        ContentField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField");
        _x.width = width;
        return _x;
    }

    @Property(name="WidthStyle")
    @JsonIgnore
    public Optional<ContentFieldWidthStyle> getWidthStyle() {
        return Optional.ofNullable(widthStyle);
    }

    public ContentField withWidthStyle(ContentFieldWidthStyle widthStyle) {
        ContentField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField");
        _x.widthStyle = widthStyle;
        return _x;
    }

    @Property(name="Format")
    @JsonIgnore
    public Optional<ContentFieldFormat> getFormat() {
        return Optional.ofNullable(format);
    }

    public ContentField withFormat(ContentFieldFormat format) {
        ContentField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String fieldName;
        private ContentFieldJustification justification;
        private String label;
        private Integer width;
        private ContentFieldWidthStyle widthStyle;
        private ContentFieldFormat format;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.changedFields = changedFields.add("FieldName");
            return this;
        }

        public Builder justification(ContentFieldJustification justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("Justification");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder width(Integer width) {
            this.width = width;
            this.changedFields = changedFields.add("Width");
            return this;
        }

        public Builder widthStyle(ContentFieldWidthStyle widthStyle) {
            this.widthStyle = widthStyle;
            this.changedFields = changedFields.add("WidthStyle");
            return this;
        }

        public Builder format(ContentFieldFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("Format");
            return this;
        }

        public ContentField build() {
            ContentField _x = new ContentField();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentField";
            _x.fieldName = fieldName;
            _x.justification = justification;
            _x.label = label;
            _x.width = width;
            _x.widthStyle = widthStyle;
            _x.format = format;
            return _x;
        }
    }

    private ContentField _copy() {
        ContentField _x = new ContentField();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.fieldName = fieldName;
        _x.justification = justification;
        _x.label = label;
        _x.width = width;
        _x.widthStyle = widthStyle;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentField[");
        b.append("FieldName=");
        b.append(this.fieldName);
        b.append(", ");
        b.append("Justification=");
        b.append(this.justification);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Width=");
        b.append(this.width);
        b.append(", ");
        b.append("WidthStyle=");
        b.append(this.widthStyle);
        b.append(", ");
        b.append("Format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
