package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentFieldFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ContentFieldCapitalizationType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Capitalization"})
public class ContentFieldTextFormat extends ContentFieldFormat implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Capitalization")
    protected ContentFieldCapitalizationType capitalization;

    protected ContentFieldTextFormat() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldTextFormat";
    }

    @Property(name="Capitalization")
    @JsonIgnore
    public Optional<ContentFieldCapitalizationType> getCapitalization() {
        return Optional.ofNullable(capitalization);
    }

    public ContentFieldTextFormat withCapitalization(ContentFieldCapitalizationType capitalization) {
        ContentFieldTextFormat _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldTextFormat");
        _x.capitalization = capitalization;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContentFieldTextFormat() {
        return new Builder();
    }

    public static final class Builder {
        private ContentFieldCapitalizationType capitalization;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder capitalization(ContentFieldCapitalizationType capitalization) {
            this.capitalization = capitalization;
            this.changedFields = changedFields.add("Capitalization");
            return this;
        }

        public ContentFieldTextFormat build() {
            ContentFieldTextFormat _x = new ContentFieldTextFormat();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldTextFormat";
            _x.capitalization = capitalization;
            return _x;
        }
    }

    private ContentFieldTextFormat _copy() {
        ContentFieldTextFormat _x = new ContentFieldTextFormat();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.capitalization = capitalization;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentFieldTextFormat[");
        b.append("Capitalization=");
        b.append(this.capitalization);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
