package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportDateRangeType", 
    "PreviousDays", 
    "QueryStartDate", 
    "NextDays", 
    "QueryEndDate", 
    "IncludeInstrumentsWithNoEvents", 
    "IncludeNullDates", 
    "ExchangeTypes"})
public class CorporateActionsIpoCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("PreviousDays")
    protected Integer previousDays;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("NextDays")
    protected Integer nextDays;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("IncludeInstrumentsWithNoEvents")
    protected Boolean includeInstrumentsWithNoEvents;

    @JsonProperty("IncludeNullDates")
    protected Boolean includeNullDates;

    @JsonProperty("ExchangeTypes")
    protected List<String> exchangeTypes;

    @JsonProperty("ExchangeTypes@nextLink")
    protected String exchangeTypesNextLink;

    protected CorporateActionsIpoCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition";
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public CorporateActionsIpoCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="PreviousDays")
    @JsonIgnore
    public Optional<Integer> getPreviousDays() {
        return Optional.ofNullable(previousDays);
    }

    public CorporateActionsIpoCondition withPreviousDays(Integer previousDays) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.previousDays = previousDays;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public CorporateActionsIpoCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="NextDays")
    @JsonIgnore
    public Optional<Integer> getNextDays() {
        return Optional.ofNullable(nextDays);
    }

    public CorporateActionsIpoCondition withNextDays(Integer nextDays) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.nextDays = nextDays;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public CorporateActionsIpoCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="IncludeInstrumentsWithNoEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeInstrumentsWithNoEvents() {
        return Optional.ofNullable(includeInstrumentsWithNoEvents);
    }

    public CorporateActionsIpoCondition withIncludeInstrumentsWithNoEvents(Boolean includeInstrumentsWithNoEvents) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
        return _x;
    }

    @Property(name="IncludeNullDates")
    @JsonIgnore
    public Optional<Boolean> getIncludeNullDates() {
        return Optional.ofNullable(includeNullDates);
    }

    public CorporateActionsIpoCondition withIncludeNullDates(Boolean includeNullDates) {
        CorporateActionsIpoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition");
        _x.includeNullDates = includeNullDates;
        return _x;
    }

    @Property(name="ExchangeTypes")
    @JsonIgnore
    public CollectionPage<String> getExchangeTypes() {
        return new CollectionPage<String>(contextPath, String.class, exchangeTypes, Optional.ofNullable(exchangeTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReportDateRangeType reportDateRangeType;
        private Integer previousDays;
        private OffsetDateTime queryStartDate;
        private Integer nextDays;
        private OffsetDateTime queryEndDate;
        private Boolean includeInstrumentsWithNoEvents;
        private Boolean includeNullDates;
        private List<String> exchangeTypes;
        private String exchangeTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder previousDays(Integer previousDays) {
            this.previousDays = previousDays;
            this.changedFields = changedFields.add("PreviousDays");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder nextDays(Integer nextDays) {
            this.nextDays = nextDays;
            this.changedFields = changedFields.add("NextDays");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder includeInstrumentsWithNoEvents(Boolean includeInstrumentsWithNoEvents) {
            this.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
            this.changedFields = changedFields.add("IncludeInstrumentsWithNoEvents");
            return this;
        }

        public Builder includeNullDates(Boolean includeNullDates) {
            this.includeNullDates = includeNullDates;
            this.changedFields = changedFields.add("IncludeNullDates");
            return this;
        }

        public Builder exchangeTypes(List<String> exchangeTypes) {
            this.exchangeTypes = exchangeTypes;
            this.changedFields = changedFields.add("ExchangeTypes");
            return this;
        }

        public Builder exchangeTypesNextLink(String exchangeTypesNextLink) {
            this.exchangeTypesNextLink = exchangeTypesNextLink;
            this.changedFields = changedFields.add("ExchangeTypes");
            return this;
        }

        public CorporateActionsIpoCondition build() {
            CorporateActionsIpoCondition _x = new CorporateActionsIpoCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIpoCondition";
            _x.reportDateRangeType = reportDateRangeType;
            _x.previousDays = previousDays;
            _x.queryStartDate = queryStartDate;
            _x.nextDays = nextDays;
            _x.queryEndDate = queryEndDate;
            _x.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
            _x.includeNullDates = includeNullDates;
            _x.exchangeTypes = exchangeTypes;
            _x.exchangeTypesNextLink = exchangeTypesNextLink;
            return _x;
        }
    }

    private CorporateActionsIpoCondition _copy() {
        CorporateActionsIpoCondition _x = new CorporateActionsIpoCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportDateRangeType = reportDateRangeType;
        _x.previousDays = previousDays;
        _x.queryStartDate = queryStartDate;
        _x.nextDays = nextDays;
        _x.queryEndDate = queryEndDate;
        _x.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
        _x.includeNullDates = includeNullDates;
        _x.exchangeTypes = exchangeTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CorporateActionsIpoCondition[");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("PreviousDays=");
        b.append(this.previousDays);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("NextDays=");
        b.append(this.nextDays);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("IncludeInstrumentsWithNoEvents=");
        b.append(this.includeInstrumentsWithNoEvents);
        b.append(", ");
        b.append("IncludeNullDates=");
        b.append(this.includeNullDates);
        b.append(", ");
        b.append("ExchangeTypes=");
        b.append(this.exchangeTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
