package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsStandardYearType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportIsoEventType;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportDateRangeType", 
    "PendingEventsPreviousDays", 
    "PendingEventsPreviousMonths", 
    "PendingEventsHours", 
    "PendingEventsMinutes", 
    "ReportIsoEvents", 
    "CorporateActionsStandardYearType", 
    "IncludeNonPendingEvents", 
    "GrossAmountOnlyForPaymentEvents", 
    "ExcludeNilPaidFromPaymentEvents", 
    "IncludeCusipCinsIn35B", 
    "Wrap35BLines"})
public class CorporateActionsIsoCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("PendingEventsPreviousDays")
    protected Integer pendingEventsPreviousDays;

    @JsonProperty("PendingEventsPreviousMonths")
    protected Integer pendingEventsPreviousMonths;

    @JsonProperty("PendingEventsHours")
    protected Integer pendingEventsHours;

    @JsonProperty("PendingEventsMinutes")
    protected Integer pendingEventsMinutes;

    @JsonProperty("ReportIsoEvents")
    protected List<ReportIsoEventType> reportIsoEvents;

    @JsonProperty("ReportIsoEvents@nextLink")
    protected String reportIsoEventsNextLink;

    @JsonProperty("CorporateActionsStandardYearType")
    protected CorporateActionsStandardYearType corporateActionsStandardYearType;

    @JsonProperty("IncludeNonPendingEvents")
    protected Boolean includeNonPendingEvents;

    @JsonProperty("GrossAmountOnlyForPaymentEvents")
    protected Boolean grossAmountOnlyForPaymentEvents;

    @JsonProperty("ExcludeNilPaidFromPaymentEvents")
    protected Boolean excludeNilPaidFromPaymentEvents;

    @JsonProperty("IncludeCusipCinsIn35B")
    protected Boolean includeCusipCinsIn35B;

    @JsonProperty("Wrap35BLines")
    protected Boolean wrap35BLines;

    protected CorporateActionsIsoCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition";
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public CorporateActionsIsoCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="PendingEventsPreviousDays")
    @JsonIgnore
    public Optional<Integer> getPendingEventsPreviousDays() {
        return Optional.ofNullable(pendingEventsPreviousDays);
    }

    public CorporateActionsIsoCondition withPendingEventsPreviousDays(Integer pendingEventsPreviousDays) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.pendingEventsPreviousDays = pendingEventsPreviousDays;
        return _x;
    }

    @Property(name="PendingEventsPreviousMonths")
    @JsonIgnore
    public Optional<Integer> getPendingEventsPreviousMonths() {
        return Optional.ofNullable(pendingEventsPreviousMonths);
    }

    public CorporateActionsIsoCondition withPendingEventsPreviousMonths(Integer pendingEventsPreviousMonths) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.pendingEventsPreviousMonths = pendingEventsPreviousMonths;
        return _x;
    }

    @Property(name="PendingEventsHours")
    @JsonIgnore
    public Optional<Integer> getPendingEventsHours() {
        return Optional.ofNullable(pendingEventsHours);
    }

    public CorporateActionsIsoCondition withPendingEventsHours(Integer pendingEventsHours) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.pendingEventsHours = pendingEventsHours;
        return _x;
    }

    @Property(name="PendingEventsMinutes")
    @JsonIgnore
    public Optional<Integer> getPendingEventsMinutes() {
        return Optional.ofNullable(pendingEventsMinutes);
    }

    public CorporateActionsIsoCondition withPendingEventsMinutes(Integer pendingEventsMinutes) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.pendingEventsMinutes = pendingEventsMinutes;
        return _x;
    }

    @Property(name="ReportIsoEvents")
    @JsonIgnore
    public CollectionPage<ReportIsoEventType> getReportIsoEvents() {
        return new CollectionPage<ReportIsoEventType>(contextPath, ReportIsoEventType.class, reportIsoEvents, Optional.ofNullable(reportIsoEventsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CorporateActionsStandardYearType")
    @JsonIgnore
    public Optional<CorporateActionsStandardYearType> getCorporateActionsStandardYearType() {
        return Optional.ofNullable(corporateActionsStandardYearType);
    }

    public CorporateActionsIsoCondition withCorporateActionsStandardYearType(CorporateActionsStandardYearType corporateActionsStandardYearType) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.corporateActionsStandardYearType = corporateActionsStandardYearType;
        return _x;
    }

    @Property(name="IncludeNonPendingEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeNonPendingEvents() {
        return Optional.ofNullable(includeNonPendingEvents);
    }

    public CorporateActionsIsoCondition withIncludeNonPendingEvents(Boolean includeNonPendingEvents) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.includeNonPendingEvents = includeNonPendingEvents;
        return _x;
    }

    @Property(name="GrossAmountOnlyForPaymentEvents")
    @JsonIgnore
    public Optional<Boolean> getGrossAmountOnlyForPaymentEvents() {
        return Optional.ofNullable(grossAmountOnlyForPaymentEvents);
    }

    public CorporateActionsIsoCondition withGrossAmountOnlyForPaymentEvents(Boolean grossAmountOnlyForPaymentEvents) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.grossAmountOnlyForPaymentEvents = grossAmountOnlyForPaymentEvents;
        return _x;
    }

    @Property(name="ExcludeNilPaidFromPaymentEvents")
    @JsonIgnore
    public Optional<Boolean> getExcludeNilPaidFromPaymentEvents() {
        return Optional.ofNullable(excludeNilPaidFromPaymentEvents);
    }

    public CorporateActionsIsoCondition withExcludeNilPaidFromPaymentEvents(Boolean excludeNilPaidFromPaymentEvents) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.excludeNilPaidFromPaymentEvents = excludeNilPaidFromPaymentEvents;
        return _x;
    }

    @Property(name="IncludeCusipCinsIn35B")
    @JsonIgnore
    public Optional<Boolean> getIncludeCusipCinsIn35B() {
        return Optional.ofNullable(includeCusipCinsIn35B);
    }

    public CorporateActionsIsoCondition withIncludeCusipCinsIn35B(Boolean includeCusipCinsIn35B) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.includeCusipCinsIn35B = includeCusipCinsIn35B;
        return _x;
    }

    @Property(name="Wrap35BLines")
    @JsonIgnore
    public Optional<Boolean> getWrap35BLines() {
        return Optional.ofNullable(wrap35BLines);
    }

    public CorporateActionsIsoCondition withWrap35BLines(Boolean wrap35BLines) {
        CorporateActionsIsoCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition");
        _x.wrap35BLines = wrap35BLines;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReportDateRangeType reportDateRangeType;
        private Integer pendingEventsPreviousDays;
        private Integer pendingEventsPreviousMonths;
        private Integer pendingEventsHours;
        private Integer pendingEventsMinutes;
        private List<ReportIsoEventType> reportIsoEvents;
        private String reportIsoEventsNextLink;
        private CorporateActionsStandardYearType corporateActionsStandardYearType;
        private Boolean includeNonPendingEvents;
        private Boolean grossAmountOnlyForPaymentEvents;
        private Boolean excludeNilPaidFromPaymentEvents;
        private Boolean includeCusipCinsIn35B;
        private Boolean wrap35BLines;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder pendingEventsPreviousDays(Integer pendingEventsPreviousDays) {
            this.pendingEventsPreviousDays = pendingEventsPreviousDays;
            this.changedFields = changedFields.add("PendingEventsPreviousDays");
            return this;
        }

        public Builder pendingEventsPreviousMonths(Integer pendingEventsPreviousMonths) {
            this.pendingEventsPreviousMonths = pendingEventsPreviousMonths;
            this.changedFields = changedFields.add("PendingEventsPreviousMonths");
            return this;
        }

        public Builder pendingEventsHours(Integer pendingEventsHours) {
            this.pendingEventsHours = pendingEventsHours;
            this.changedFields = changedFields.add("PendingEventsHours");
            return this;
        }

        public Builder pendingEventsMinutes(Integer pendingEventsMinutes) {
            this.pendingEventsMinutes = pendingEventsMinutes;
            this.changedFields = changedFields.add("PendingEventsMinutes");
            return this;
        }

        public Builder reportIsoEvents(List<ReportIsoEventType> reportIsoEvents) {
            this.reportIsoEvents = reportIsoEvents;
            this.changedFields = changedFields.add("ReportIsoEvents");
            return this;
        }

        public Builder reportIsoEventsNextLink(String reportIsoEventsNextLink) {
            this.reportIsoEventsNextLink = reportIsoEventsNextLink;
            this.changedFields = changedFields.add("ReportIsoEvents");
            return this;
        }

        public Builder corporateActionsStandardYearType(CorporateActionsStandardYearType corporateActionsStandardYearType) {
            this.corporateActionsStandardYearType = corporateActionsStandardYearType;
            this.changedFields = changedFields.add("CorporateActionsStandardYearType");
            return this;
        }

        public Builder includeNonPendingEvents(Boolean includeNonPendingEvents) {
            this.includeNonPendingEvents = includeNonPendingEvents;
            this.changedFields = changedFields.add("IncludeNonPendingEvents");
            return this;
        }

        public Builder grossAmountOnlyForPaymentEvents(Boolean grossAmountOnlyForPaymentEvents) {
            this.grossAmountOnlyForPaymentEvents = grossAmountOnlyForPaymentEvents;
            this.changedFields = changedFields.add("GrossAmountOnlyForPaymentEvents");
            return this;
        }

        public Builder excludeNilPaidFromPaymentEvents(Boolean excludeNilPaidFromPaymentEvents) {
            this.excludeNilPaidFromPaymentEvents = excludeNilPaidFromPaymentEvents;
            this.changedFields = changedFields.add("ExcludeNilPaidFromPaymentEvents");
            return this;
        }

        public Builder includeCusipCinsIn35B(Boolean includeCusipCinsIn35B) {
            this.includeCusipCinsIn35B = includeCusipCinsIn35B;
            this.changedFields = changedFields.add("IncludeCusipCinsIn35B");
            return this;
        }

        public Builder wrap35BLines(Boolean wrap35BLines) {
            this.wrap35BLines = wrap35BLines;
            this.changedFields = changedFields.add("Wrap35BLines");
            return this;
        }

        public CorporateActionsIsoCondition build() {
            CorporateActionsIsoCondition _x = new CorporateActionsIsoCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsIsoCondition";
            _x.reportDateRangeType = reportDateRangeType;
            _x.pendingEventsPreviousDays = pendingEventsPreviousDays;
            _x.pendingEventsPreviousMonths = pendingEventsPreviousMonths;
            _x.pendingEventsHours = pendingEventsHours;
            _x.pendingEventsMinutes = pendingEventsMinutes;
            _x.reportIsoEvents = reportIsoEvents;
            _x.reportIsoEventsNextLink = reportIsoEventsNextLink;
            _x.corporateActionsStandardYearType = corporateActionsStandardYearType;
            _x.includeNonPendingEvents = includeNonPendingEvents;
            _x.grossAmountOnlyForPaymentEvents = grossAmountOnlyForPaymentEvents;
            _x.excludeNilPaidFromPaymentEvents = excludeNilPaidFromPaymentEvents;
            _x.includeCusipCinsIn35B = includeCusipCinsIn35B;
            _x.wrap35BLines = wrap35BLines;
            return _x;
        }
    }

    private CorporateActionsIsoCondition _copy() {
        CorporateActionsIsoCondition _x = new CorporateActionsIsoCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportDateRangeType = reportDateRangeType;
        _x.pendingEventsPreviousDays = pendingEventsPreviousDays;
        _x.pendingEventsPreviousMonths = pendingEventsPreviousMonths;
        _x.pendingEventsHours = pendingEventsHours;
        _x.pendingEventsMinutes = pendingEventsMinutes;
        _x.reportIsoEvents = reportIsoEvents;
        _x.corporateActionsStandardYearType = corporateActionsStandardYearType;
        _x.includeNonPendingEvents = includeNonPendingEvents;
        _x.grossAmountOnlyForPaymentEvents = grossAmountOnlyForPaymentEvents;
        _x.excludeNilPaidFromPaymentEvents = excludeNilPaidFromPaymentEvents;
        _x.includeCusipCinsIn35B = includeCusipCinsIn35B;
        _x.wrap35BLines = wrap35BLines;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CorporateActionsIsoCondition[");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("PendingEventsPreviousDays=");
        b.append(this.pendingEventsPreviousDays);
        b.append(", ");
        b.append("PendingEventsPreviousMonths=");
        b.append(this.pendingEventsPreviousMonths);
        b.append(", ");
        b.append("PendingEventsHours=");
        b.append(this.pendingEventsHours);
        b.append(", ");
        b.append("PendingEventsMinutes=");
        b.append(this.pendingEventsMinutes);
        b.append(", ");
        b.append("ReportIsoEvents=");
        b.append(this.reportIsoEvents);
        b.append(", ");
        b.append("CorporateActionsStandardYearType=");
        b.append(this.corporateActionsStandardYearType);
        b.append(", ");
        b.append("IncludeNonPendingEvents=");
        b.append(this.includeNonPendingEvents);
        b.append(", ");
        b.append("GrossAmountOnlyForPaymentEvents=");
        b.append(this.grossAmountOnlyForPaymentEvents);
        b.append(", ");
        b.append("ExcludeNilPaidFromPaymentEvents=");
        b.append(this.excludeNilPaidFromPaymentEvents);
        b.append(", ");
        b.append("IncludeCusipCinsIn35B=");
        b.append(this.includeCusipCinsIn35B);
        b.append(", ");
        b.append("Wrap35BLines=");
        b.append(this.wrap35BLines);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
